/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.ServerStat;
import scouter.server.db.DBCtr$;
import scouter.server.db.ZipkinSpanWR;
import scouter.server.db.span.ZipkinSpanDataWriter;
import scouter.server.db.span.ZipkinSpanDataWriter$;
import scouter.server.db.span.ZipkinSpanIndex;
import scouter.server.db.span.ZipkinSpanIndex$;
import scouter.server.util.OftenAction$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.IClose;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public final class ZipkinSpanWR$ {
    public static final ZipkinSpanWR$ MODULE$;
    private final long MAX_IDLE;
    private final String SPAN_DIR;
    private final String SPAN_PREFIX;
    private final RequestQueue<ZipkinSpanWR.SpanData> queue;
    private final Map<Object, ZipkinSpanWR.StorageContainer> dailyContainer;

    static {
        new ZipkinSpanWR$();
    }

    public long MAX_IDLE() {
        return this.MAX_IDLE;
    }

    public String SPAN_DIR() {
        return this.SPAN_DIR;
    }

    public String SPAN_PREFIX() {
        return this.SPAN_PREFIX;
    }

    public RequestQueue<ZipkinSpanWR.SpanData> queue() {
        return this.queue;
    }

    public Map<Object, ZipkinSpanWR.StorageContainer> dailyContainer() {
        return this.dailyContainer;
    }

    public void add(long time, long gid, byte[] data) {
        boolean ok = this.queue().put(new ZipkinSpanWR.SpanData(time, gid, data));
        if (!ok) {
            Logger$.MODULE$.println("SZ144", 10, "queue exceeded!! - ZipkinSpanWR");
        }
    }

    public void closeAll() {
        this.dailyContainer().values().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IClose apply(ZipkinSpanWR.StorageContainer container) {
                FileUtil.close(container.index());
                return FileUtil.close(container.writer());
            }
        });
        this.dailyContainer().clear();
    }

    public void close(long time) {
        this.dailyContainer().get((Object)BoxesRunTime.boxToLong((long)time)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IClose apply(ZipkinSpanWR.StorageContainer container) {
                FileUtil.close(container.index());
                return FileUtil.close(container.writer());
            }
        });
        this.dailyContainer().remove((Object)BoxesRunTime.boxToLong((long)time));
    }

    public Tuple2<ZipkinSpanIndex, ZipkinSpanDataWriter> open(long time) {
        String date = DateUtil.yyyymmdd(time);
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = f.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)f.mkdirs());
            String file = new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.SPAN_PREFIX()).toString();
            ZipkinSpanIndex index = ZipkinSpanIndex$.MODULE$.open(file);
            ZipkinSpanDataWriter writer = ZipkinSpanDataWriter$.MODULE$.open(date, file);
            return new Tuple2((Object)index, (Object)writer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close(time);
            return new Tuple2(null, null);
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append(this.SPAN_DIR());
        return sb.toString();
    }

    private ZipkinSpanWR$() {
        MODULE$ = this;
        this.MAX_IDLE = 1800000L;
        this.SPAN_DIR = "/span";
        this.SPAN_PREFIX = "span";
        this.queue = new RequestQueue(Configure.getInstance().span_queue_size);
        this.dailyContainer = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ThreadScala$.MODULE$.start("scouter.server.db.ZipkinSpanDataFileWatcher", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (DBCtr$.MODULE$.running()) {
                    ThreadUtil.sleep(300000L);
                    long now = System.currentTimeMillis();
                    ((MapLike)ZipkinSpanWR$.MODULE$.dailyContainer().filter((Function1)new Serializable(this, now){
                        public static final long serialVersionUID = 0L;
                        private final long now$1;

                        public final boolean apply(Tuple2<Object, ZipkinSpanWR.StorageContainer> kv) {
                            return this.now$1 - ((ZipkinSpanWR.StorageContainer)kv._2()).lastAccess() > ((ZipkinSpanWR.StorageContainer)kv._2()).idleLimit();
                        }
                        {
                            this.now$1 = now$1;
                        }
                    })).keys().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(long k) {
                            this.apply$mcVJ$sp(k);
                        }

                        public void apply$mcVJ$sp(long k) {
                            ZipkinSpanWR$.MODULE$.close(k);
                        }
                    });
                }
            }
        });
        ThreadScala$.MODULE$.start("scouter.server.db.ZipkinSpanWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    ZipkinSpanWR.StorageContainer container;
                    ZipkinSpanWR.SpanData m;
                    block5: {
                        if (!DBCtr$.MODULE$.running()) {
                            ZipkinSpanWR$.MODULE$.closeAll();
                            return;
                        }
                        m = ZipkinSpanWR$.MODULE$.queue().get();
                        ServerStat.put("zipkin-span.db.queue", ZipkinSpanWR$.MODULE$.queue().size());
                        try {
                            long currentDateUnit = DateUtil.getDateUnit(m.time());
                            container = (ZipkinSpanWR.StorageContainer)ZipkinSpanWR$.MODULE$.dailyContainer().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)currentDateUnit), (Function0)new Serializable(this, m){
                                public static final long serialVersionUID = 0L;
                                private final ZipkinSpanWR.SpanData m$1;

                                public final ZipkinSpanWR.StorageContainer apply() {
                                    Tuple2<ZipkinSpanIndex, ZipkinSpanDataWriter> tuple2 = ZipkinSpanWR$.MODULE$.open(this.m$1.time());
                                    if (tuple2 != null) {
                                        Tuple2 tuple22;
                                        ZipkinSpanIndex index = (ZipkinSpanIndex)tuple2._1();
                                        ZipkinSpanDataWriter writer = (ZipkinSpanDataWriter)tuple2._2();
                                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)index, (Object)writer);
                                        ZipkinSpanIndex index2 = (ZipkinSpanIndex)tuple23._1();
                                        ZipkinSpanDataWriter writer2 = (ZipkinSpanDataWriter)tuple23._2();
                                        return new ZipkinSpanWR.StorageContainer(ZipkinSpanWR$.MODULE$.MAX_IDLE(), System.currentTimeMillis(), index2, writer2);
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.m$1 = m$1;
                                }
                            });
                            if (container.index() == null) {
                                OftenAction$.MODULE$.act("ZipkinSpanWR", 10, (Function0<BoxedUnit>)new Serializable(this, currentDateUnit){
                                    public static final long serialVersionUID = 0L;
                                    private final long currentDateUnit$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        ZipkinSpanWR$.MODULE$.dailyContainer().remove((Object)BoxesRunTime.boxToLong((long)this.currentDateUnit$1));
                                        ZipkinSpanWR$.MODULE$.queue().clear();
                                    }
                                    {
                                        this.currentDateUnit$1 = currentDateUnit$1;
                                    }
                                });
                                Logger$.MODULE$.println("SZ143", 10, "can't open ZipkinSpanWR");
                            }
                            break block5;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        continue;
                    }
                    long location = container.writer().write(m.data());
                    container.index().setByTime(m.time(), location);
                    container.index().setByGxid(m.gxid(), location);
                }
            }
        });
    }
}

