/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scouter.io.DataInputX;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.db.io.ITEM;
import scouter.server.db.io.IndexKeyFile$;
import scouter.server.db.io.MemHashBlock;
import scouter.server.db.io.RealKeyFile;
import scouter.util.CompareUtil;
import scouter.util.HashUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001-\u0011A\"\u00138eKb\\U-\u001f$jY\u0016T!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\t!'M\u0003\u0002\b\u0011\u000511/\u001a:wKJT\u0011!C\u0001\bg\u000e|W\u000f^3s\u0007\u0001\u00192\u0001\u0001\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0011)H/\u001b7\n\u0005e1\"AB%DY>\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015y\u0006/\u0019;i!\ti2E\u0004\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011s$\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012 \u0011!9\u0003A!A!\u0002\u0013A\u0013\u0001\u00035bg\"\u001c\u0016N_3\u0011\u0005yI\u0013B\u0001\u0016 \u0005\rIe\u000e\u001e\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u0002\u0014\u0007\u0005\u00020\u00015\t!\u0001C\u0003\u001cW\u0001\u0007A\u0004C\u0004(WA\u0005\t\u0019\u0001\u0015\t\u000fM\u0002!\u0019!C\u0001i\u0005!1m\u001c8g+\u0005)\u0004C\u0001\u001c8\u001b\u00051\u0011B\u0001\u001d\u0007\u0005%\u0019uN\u001c4jOV\u0014X\r\u0003\u0004;\u0001\u0001\u0006I!N\u0001\u0006G>tg\r\t\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0003\ti%)F\u0001)\u0011\u0019y\u0004\u0001)A\u0005Q\u0005\u0019QJ\u0011\u0011\t\u000f\u0005\u0003!\u0019!C\u0001\u0005\u0006!\u0001/\u0019;i+\u0005a\u0002B\u0002#\u0001A\u0003%A$A\u0003qCRD\u0007\u0005C\u0004G\u0001\t\u0007I\u0011A$\u0002\u0013!\f7\u000f\u001b\"m_\u000e\\W#\u0001%\u0011\u0005=J\u0015B\u0001&\u0003\u00051iU-\u001c%bg\"\u0014En\\2l\u0011\u0019a\u0005\u0001)A\u0005\u0011\u0006Q\u0001.Y:i\u00052|7m\u001b\u0011\t\u000f9\u0003!\u0019!C\u0001\u001f\u000691.Z=GS2,W#\u0001)\u0011\u0005=\n\u0016B\u0001*\u0003\u0005-\u0011V-\u00197LKf4\u0015\u000e\\3\t\rQ\u0003\u0001\u0015!\u0003Q\u0003!YW-\u001f$jY\u0016\u0004\u0003\"\u0002,\u0001\t\u00039\u0016A\u00029vi\u0006cG\u000e\u0006\u0002)1\")\u0011,\u0016a\u0001]\u0005)A/\u00192mK\")1\f\u0001C\u00019\u0006\u0019\u0001/\u001e;\u0015\u0007u\u0003\u0007\u000e\u0005\u0002\u001f=&\u0011ql\b\u0002\b\u0005>|G.Z1o\u0011\u0015\t'\f1\u0001c\u0003!Ig\u000eZ3y\u0017\u0016L\bc\u0001\u0010dK&\u0011Am\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003=\u0019L!aZ\u0010\u0003\t\tKH/\u001a\u0005\u0006Sj\u0003\rAY\u0001\u000bI\u0006$\u0018m\u00144gg\u0016$\b\"B6\u0001\t\u0003a\u0017AB;qI\u0006$X\rF\u0002^[>DQA\u001c6A\u0002\t\f1a[3z\u0011\u0015\u0001(\u000e1\u0001c\u0003\u00151\u0018\r\\;f\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\r9W\r\u001e\u000b\u0003ERDQA\\9A\u0002\tDQA\u001e\u0001\u0005\u0002]\fa\u0001[1t\u0017\u0016LHCA/y\u0011\u0015qW\u000f1\u0001c\u0011\u0015Q\b\u0001\"\u0001|\u0003\u00199W\r^!mYR\u0019A0a\u0001\u0011\u0007u|(-D\u0001\u007f\u0015\t9\u0002#C\u0002\u0002\u0002y\u0014A\u0001T5ti\")a.\u001fa\u0001E\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011A\u00023fY\u0016$X\rF\u0002)\u0003\u0017AaA\\A\u0003\u0001\u0004\u0011\u0007bBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\u0005e\u0016\fG\r\u0006\u0003\u0002\u0014\u0005e\u0001c\u0001\u0010\u0002\u0016%\u0019\u0011qC\u0010\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037\ti\u00011\u0001\u0002\u001e\u00059\u0001.\u00198eY\u0016\u0014\bc\u0002\u0010\u0002 \t\u0014\u00171E\u0005\u0004\u0003Cy\"!\u0003$v]\u000e$\u0018n\u001c83!\rq\u0012QE\u0005\u0004\u0003Oy\"aA!os\"9\u0011q\u0002\u0001\u0005\u0002\u0005-BCBA\n\u0003[\ty\u0003\u0003\u0005\u0002\u001c\u0005%\u0002\u0019AA\u000f\u0011!\t\t$!\u000bA\u0002\u0005M\u0012A\u0002:fC\u0012,'\u000f\u0005\u0004\u001f\u0003k\tIDY\u0005\u0004\u0003oy\"!\u0003$v]\u000e$\u0018n\u001c82!\rq\u00121H\u0005\u0004\u0003{y\"\u0001\u0002'p]\u001eDq!!\u0011\u0001\t\u0003\t\u0019%A\u0004hKR\u001cF/\u0019;\u0015\u0005\u0005\u0015\u0003CB?\u0002Hq\tY%C\u0002\u0002Jy\u00141!T1q!\ri\u0011QJ\u0005\u0004\u0003\u001fr!A\u0002(v[\n,'\u000fC\u0004\u0002T\u0001!\t%!\u0016\u0002\u000b\rdwn]3\u0015\u0005\u0005Mq!CA-\u0005\u0005\u0005\t\u0012AA.\u00031Ie\u000eZ3y\u0017\u0016Lh)\u001b7f!\ry\u0013Q\f\u0004\t\u0003\t\t\t\u0011#\u0001\u0002`M!\u0011QLA1!\rq\u00121M\u0005\u0004\u0003Kz\"AB!osJ+g\rC\u0004-\u0003;\"\t!!\u001b\u0015\u0005\u0005m\u0003BCA7\u0003;\n\n\u0011\"\u0001\u0002p\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u001d+\u0007!\n\u0019h\u000b\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014!C;oG\",7m[3e\u0015\r\tyhH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAB\u0003s\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class IndexKeyFile
implements IClose {
    private final Configure conf = Configure.getInstance();
    private final int MB;
    private final String path;
    private final MemHashBlock hashBlock;
    private final RealKeyFile keyFile;

    public static int $lessinit$greater$default$2() {
        return IndexKeyFile$.MODULE$.$lessinit$greater$default$2();
    }

    public Configure conf() {
        return this.conf;
    }

    public int MB() {
        return this.MB;
    }

    public String path() {
        return this.path;
    }

    public MemHashBlock hashBlock() {
        return this.hashBlock;
    }

    public RealKeyFile keyFile() {
        return this.keyFile;
    }

    public int putAll(IndexKeyFile table) {
        IntRef count = IntRef.create((int)0);
        table.read((Function2<byte[], byte[], Object>)new Serializable(this, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexKeyFile $outer;
            private final IntRef count$1;

            public final Object apply(byte[] key, byte[] data) {
                BoxedUnit boxedUnit;
                try {
                    this.$outer.put(key, data);
                    ++this.count$1.elem;
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Exception exception) {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
            }
        });
        return count.elem;
    }

    public boolean put(byte[] indexKey, byte[] dataOffset) {
        if (indexKey == null || dataOffset == null) {
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(indexKey);
        long prevKeyPos = this.hashBlock().get(keyHash);
        long newKeyPos = this.keyFile().append(prevKeyPos, indexKey, dataOffset);
        this.hashBlock().put(keyHash, newKeyPos);
        return true;
    }

    public boolean update(byte[] key, byte[] value) {
        if (key == null || value == null) {
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        return this.keyFile().update(pos, key, value);
    }

    public byte[] get(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long realKeyPos = this.hashBlock().get(keyHash);
        try {
            int looping = 0;
            while (realKeyPos > 0L) {
                byte[] oKey;
                if (!this.keyFile().isDeleted(realKeyPos) && CompareUtil.equals(oKey = this.keyFile().getTimeKey(realKeyPos), key)) {
                    return this.keyFile().getDataPos(realKeyPos);
                }
                realKeyPos = this.keyFile().getPrevPos(realKeyPos);
                ++looping;
            }
            if (looping > this.conf().log_index_traversal_warning_count) {
                Logger$.MODULE$.println("S152", 10, new StringBuilder().append((Object)"[warn] Too many index deep searching. ").append((Object)BoxesRunTime.boxToLong((long)DataInputX.toLong(key, 0))).toString());
            }
            return null;
        }
        catch (IOException iOException) {
            Logger$.MODULE$.println("S124", new StringBuilder().append((Object)"pos=").append((Object)BoxesRunTime.boxToLong((long)realKeyPos)).append((Object)" keyFile.lengrh=").append((Object)BoxesRunTime.boxToLong((long)this.keyFile().getLength())).toString());
            throw iOException;
        }
    }

    public boolean hasKey(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getTimeKey(pos), key)) {
                return true;
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return false;
    }

    public List<byte[]> getAll(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        ArrayList<byte[]> out = new ArrayList<byte[]>();
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            Object object = !this.keyFile().isDeleted(pos) ? (CompareUtil.equals(okey = this.keyFile().getTimeKey(pos), key) ? BoxesRunTime.boxToBoolean((boolean)out.add(this.keyFile().getDataPos(pos))) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            pos = this.keyFile().getPrevPos(pos);
        }
        return out;
    }

    public int delete(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        int deleted = 0;
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getTimeKey(pos), key)) {
                this.keyFile().setDelete(pos, true);
                ++deleted;
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return deleted;
    }

    public void read(Function2<byte[], byte[], Object> handler) {
        if (this.keyFile() == null) {
            return;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length && pos > 0L) {
                ITEM r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() ? handler.apply((Object)r.timeKey(), (Object)r.dataPos()) : BoxedUnit.UNIT;
                ++done;
                pos = r.offset();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S125", new StringBuilder().append((Object)this.keyFile().path()).append((Object)" : read=").append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
    }

    public void read(Function2<byte[], byte[], Object> handler, Function1<Object, byte[]> reader) {
        if (this.keyFile() == null) {
            return;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length && pos > 0L) {
                ITEM r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() ? handler.apply((Object)r.timeKey(), reader.apply((Object)BoxesRunTime.boxToLong((long)DataInputX.toLong5(r.dataPos(), 0)))) : BoxedUnit.UNIT;
                ++done;
                pos = r.offset();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S126", new StringBuilder().append((Object)this.keyFile().path()).append((Object)" : read=").append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
    }

    public Map<String, Number> getStat() {
        int deleted = 0;
        int count = 0;
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        while (pos < length && pos > 0L) {
            ITEM r = this.keyFile().getRecord(pos);
            if (r.deleted()) {
                ++deleted;
            } else {
                ++count;
            }
            pos = r.offset();
        }
        int scatter = this.hashBlock().getCount();
        HashMap<String, Number> out = new HashMap<String, Number>();
        out.put("count", Predef$.MODULE$.int2Integer(count));
        out.put("scatter", Predef$.MODULE$.int2Integer(scatter));
        out.put("deleted", Predef$.MODULE$.int2Integer(deleted));
        out.put("scan", Predef$.MODULE$.float2Float((float)(count + deleted) / (float)scatter));
        return out;
    }

    @Override
    public void close() {
        this.hashBlock().close();
        this.keyFile().close();
    }

    public IndexKeyFile(String _path, int hashSize) {
        this.MB = 0x100000;
        this.path = _path;
        this.hashBlock = new MemHashBlock(this.path(), hashSize * this.MB());
        this.keyFile = new RealKeyFile(this.path());
    }
}

