/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.server.Logger$;
import scouter.server.db.io.ITEM;
import scouter.server.db.io.MemTimeBlock;
import scouter.server.db.io.RealKeyFile;
import scouter.server.util.EnumerScala$;
import scouter.util.BytesUtil;
import scouter.util.CompareUtil;
import scouter.util.DateUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001-\u0011Q\"\u00138eKb$\u0016.\\3GS2,'BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u0005\u0011AM\u0019\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000fM\u001cw.\u001e;fe\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005!Q\u000f^5m\u0013\tIbC\u0001\u0004J\u00072|7/\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005)q\f]1uQB\u0011Qd\t\b\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!eH\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#AB*ue&twM\u0003\u0002#?!)q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"\"!K\u0016\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000bm1\u0003\u0019\u0001\u000f\t\u000f5\u0002\u0001\u0019!C\t]\u0005!\u0001/\u0019;i+\u0005a\u0002b\u0002\u0019\u0001\u0001\u0004%\t\"M\u0001\ta\u0006$\bn\u0018\u0013fcR\u0011!'\u000e\t\u0003=MJ!\u0001N\u0010\u0003\tUs\u0017\u000e\u001e\u0005\bm=\n\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\u0007q\u0001\u0001\u000b\u0015\u0002\u000f\u0002\u000bA\fG\u000f\u001b\u0011\t\u000fi\u0002\u0001\u0019!C\tw\u0005iA/[7f\u00052|7m\u001b%bg\",\u0012\u0001\u0010\t\u0003UuJ!A\u0010\u0002\u0003\u00195+W\u000eV5nK\ncwnY6\t\u000f\u0001\u0003\u0001\u0019!C\t\u0003\u0006\tB/[7f\u00052|7m\u001b%bg\"|F%Z9\u0015\u0005I\u0012\u0005b\u0002\u001c@\u0003\u0003\u0005\r\u0001\u0010\u0005\u0007\t\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u001dQLW.\u001a\"m_\u000e\\\u0007*Y:iA!9a\t\u0001a\u0001\n#9\u0015aB6fs\u001aKG.Z\u000b\u0002\u0011B\u0011!&S\u0005\u0003\u0015\n\u00111BU3bY.+\u0017PR5mK\"9A\n\u0001a\u0001\n#i\u0015aC6fs\u001aKG.Z0%KF$\"A\r(\t\u000fYZ\u0015\u0011!a\u0001\u0011\"1\u0001\u000b\u0001Q!\n!\u000b\u0001b[3z\r&dW\r\t\u0005\u0006%\u0002!\taU\u0001\u0004aV$Hc\u0001+X3B\u0011a$V\u0005\u0003-~\u0011A\u0001T8oO\")\u0001,\u0015a\u0001)\u0006!A/[7f\u0011\u0015Q\u0016\u000b1\u0001\\\u0003\u001d!\u0017\r^1Q_N\u00042A\b/_\u0013\tivDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001f?&\u0011\u0001m\b\u0002\u0005\u0005f$X\rC\u0003c\u0001\u0011%1-A\u0005hKR\u001cVmY!mYR\u0019A-a\u000f\u0011\u0007\u0015<\u0017.D\u0001g\u0015\t9\u0002#\u0003\u0002iM\nI\u0011I\u001d:bs2K7\u000f\u001e\t\u0003U.l\u0011\u0001\u0001\u0004\u0005Y\u0002\u0001QN\u0001\u0006US6,Gk\u001c#bi\u0006\u001c2a\u001b8r!\tqr.\u0003\u0002q?\t1\u0011I\\=SK\u001a\u00042!\u0004:j\u0013\t\u0019hB\u0001\u0006D_6\u0004\u0018M]1cY\u0016D\u0001\"^6\u0003\u0002\u0003\u0006I\u0001V\u0001\u0006?RLW.\u001a\u0005\to.\u0014\t\u0011)A\u00057\u0006Aq\fZ1uCB{7\u000fC\u0003(W\u0012\u0005\u0011\u0010F\u0002junDQ!\u001e=A\u0002QCQa\u001e=A\u0002mCq\u0001W6C\u0002\u0013\u0005Q0F\u0001U\u0011\u0019y8\u000e)A\u0005)\u0006)A/[7fA!A!l\u001bb\u0001\n\u0003\t\u0019!F\u0001\\\u0011\u001d\t9a\u001bQ\u0001\nm\u000b\u0001\u0002Z1uCB{7\u000f\t\u0005\b\u0003\u0017YG\u0011IA\u0007\u0003%\u0019w.\u001c9be\u0016$v\u000e\u0006\u0003\u0002\u0010\u0005U\u0001c\u0001\u0010\u0002\u0012%\u0019\u00111C\u0010\u0003\u0007%sG\u000fC\u0004\u0002\u0018\u0005%\u0001\u0019A5\u0002\u0003QDq!a\u0007l\t\u0003\ni\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\t)\u0003E\u0002\u001f\u0003CI1!a\t \u0005\u001d\u0011un\u001c7fC:D\u0001\"a\n\u0002\u001a\u0001\u0007\u0011\u0011F\u0001\u0004_\nT\u0007c\u0001\u0010\u0002,%\u0019\u0011QF\u0010\u0003\u0007\u0005s\u0017\u0010C\u0004\u00022-$\t%a\r\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0004\t\u000f\u0005]2\u000e\"\u0011\u0002:\u0005AAo\\*ue&tw\rF\u0001\u001d\u0011\u0015A\u0016\r1\u0001U\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003\n1bZ3u'\u0016\u001c\u0017\t\u001c7WeQ!\u00111IA.!\u0015\t)%!\u0016j\u001d\u0011\t9%!\u0015\u000f\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014\u000b\u0003\u0019a$o\\8u}%\t\u0001%C\u0002\u0002T}\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002X\u0005e#\u0001\u0002'jgRT1!a\u0015 \u0011\u0019A\u0016Q\ba\u0001)\"9\u0011q\f\u0001\u0005\n\u0005\u0005\u0014aD4fi\u0012\u000bG/\u0019)pg\u001aK'o\u001d;\u0015\u000bm\u000b\u0019'a\u001a\t\u000f\u0005\u0015\u0014Q\fa\u0001)\u00061ql\u001d;j[\u0016Dq!!\u001b\u0002^\u0001\u0007A+\u0001\u0004`KRLW.\u001a\u0005\b\u0003?\u0002A\u0011BA7)\rY\u0016q\u000e\u0005\u00071\u0006-\u0004\u0019\u0001+\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v\u0005qq-\u001a;ECR\f\u0007k\\:MCN$H#B.\u0002x\u0005e\u0004bBA3\u0003c\u0002\r\u0001\u0016\u0005\b\u0003S\n\t\b1\u0001U\u0011\u001d\t\u0019\b\u0001C\u0005\u0003{\"2aWA@\u0011\u0019A\u00161\u0010a\u0001)\"9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0015AE4fiN#\u0018M\u001d;F]\u0012$\u0015\r^1Q_N$b!a\"\u0002\u000e\u0006E\u0005#\u0002\u0010\u0002\nn[\u0016bAAF?\t1A+\u001e9mKJBq!a$\u0002\u0002\u0002\u0007A+A\u0003ti&lW\rC\u0004\u0002\u0014\u0006\u0005\u0005\u0019\u0001+\u0002\u000b\u0015$\u0018.\\3\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006Iq-\u001a;ESJ,7\r\u001e\u000b\u0004S\u0006m\u0005bBAO\u0003+\u0003\r\u0001V\u0001\u0004a>\u001c\bbBAQ\u0001\u0011\u0005\u00111U\u0001\u0007I\u0016dW\r^3\u0015\t\u0005=\u0011Q\u0015\u0005\u00071\u0006}\u0005\u0019\u0001+\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u0006!!/Z1e)\u001d\u0011\u0014QVAX\u0003cCq!!\u001a\u0002(\u0002\u0007A\u000bC\u0004\u0002\u0014\u0006\u001d\u0006\u0019\u0001+\t\u0011\u0005M\u0016q\u0015a\u0001\u0003k\u000bq\u0001[1oI2,'\u000fE\u0004\u001f\u0003o#6,!\u000b\n\u0007\u0005evDA\u0005Gk:\u001cG/[8oe!9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0016a\u0003:fC\u00124%o\\7F]\u0012$rAMAa\u0003\u0007\f)\rC\u0004\u0002\u0010\u0006m\u0006\u0019\u0001+\t\u000f\u0005%\u00141\u0018a\u0001)\"A\u00111WA^\u0001\u0004\t)\fC\u0004\u0002*\u0002!\t!!3\u0015\u0013I\nY-!4\u0002P\u0006E\u0007bBA3\u0003\u000f\u0004\r\u0001\u0016\u0005\b\u0003'\u000b9\r1\u0001U\u0011!\t\u0019,a2A\u0002\u0005U\u0006\u0002CAj\u0003\u000f\u0004\r!!6\u0002\rI,\u0017\rZ3s!\u0015q\u0012q\u001b+\\\u0013\r\tIn\b\u0002\n\rVt7\r^5p]FBq!!8\u0001\t\u0003\ty.\u0001\tsK\u0006$')\u001f'j[&$8i\\;oiRi!'!9\u0002d\u0006\u0015\u0018\u0011^Aw\u0003cDq!a$\u0002\\\u0002\u0007A\u000bC\u0004\u0002\u0014\u0006m\u0007\u0019\u0001+\t\u000f\u0005\u001d\u00181\u001ca\u0001)\u0006qA.Y:u\u0005V\u001c7.\u001a;US6,\u0007\u0002CAv\u00037\u0004\r!a\u0004\u0002\u00151LW.\u001b;D_VtG\u000f\u0003\u0005\u00024\u0006m\u0007\u0019AAx!\u001dq\u0012q\u0017+\\\u0003\u001fA\u0001\"a5\u0002\\\u0002\u0007\u0011Q\u001b\u0005\b\u0003{\u0003A\u0011AA{)%\u0011\u0014q_A}\u0003w\fi\u0010C\u0004\u0002\u0010\u0006M\b\u0019\u0001+\t\u000f\u0005%\u00141\u001fa\u0001)\"A\u00111WAz\u0001\u0004\t)\f\u0003\u0005\u0002T\u0006M\b\u0019AAk\u0011\u001d\tI\u000b\u0001C\u0001\u0005\u0003!2A\rB\u0002\u0011!\t\u0019,a@A\u0002\t\u0015\u0001c\u0002\u0010\u00028n[\u0016\u0011\u0006\u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0003\u0015\u0019Gn\\:f)\u0005\u0011\u0004")
public class IndexTimeFile
implements IClose {
    private String path;
    private MemTimeBlock timeBlockHash;
    private RealKeyFile keyFile;

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    public MemTimeBlock timeBlockHash() {
        return this.timeBlockHash;
    }

    public void timeBlockHash_$eq(MemTimeBlock x$1) {
        this.timeBlockHash = x$1;
    }

    public RealKeyFile keyFile() {
        return this.keyFile;
    }

    public void keyFile_$eq(RealKeyFile x$1) {
        this.keyFile = x$1;
    }

    public long put(long time, byte[] dataPos) {
        if (time <= 0L || dataPos == null) {
            throw new IOException("invalid key/value");
        }
        long prevKeyPos = this.timeBlockHash().get(time);
        long newKeyPos = this.keyFile().append(prevKeyPos, DataOutputX.toBytes(time), dataPos);
        this.timeBlockHash().put(time, newKeyPos);
        this.timeBlockHash().addCount(1);
        return newKeyPos;
    }

    private ArrayList<TimeToData> getSecAll(long time) {
        if (time <= 0L) {
            throw new IOException("invalid key");
        }
        TreeSet<TimeToData> set = new TreeSet<TimeToData>();
        long pos = this.timeBlockHash().get(time);
        while (pos > 0L) {
            Object object;
            if (!this.keyFile().isDeleted(pos)) {
                ITEM record = this.keyFile().getRecord(pos);
                object = BoxesRunTime.boxToBoolean((boolean)set.add(new TimeToData(DataInputX.toLong(record.timeKey(), 0), record.dataPos())));
            } else {
                object = BoxedUnit.UNIT;
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return new ArrayList<TimeToData>(set);
    }

    private List<TimeToData> getSecAllV2(long time) {
        if (time <= 0L) {
            throw new IOException("invalid key");
        }
        ListBuffer buffer = new ListBuffer();
        long pos = this.timeBlockHash().get(time);
        while (pos > 0L) {
            BoxedUnit boxedUnit;
            if (!this.keyFile().isDeleted(pos)) {
                ITEM record = this.keyFile().getRecord(pos);
                boxedUnit = buffer.$plus$eq((Object)new TimeToData(DataInputX.toLong(record.timeKey(), 0), record.dataPos()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return buffer.toList();
    }

    private byte[] getDataPosFirst(long _stime, long _etime) {
        if (_stime <= 0L || _etime <= 0L) {
            throw new IOException("invalid key");
        }
        long stime = _stime;
        byte[] dataPos = this.getDataPosFirst(stime);
        for (int i = 0; dataPos == null && i < 172800 && stime <= _etime; ++i) {
            dataPos = this.getDataPosFirst(stime += 500L);
        }
        return dataPos;
    }

    private byte[] getDataPosFirst(long time) {
        if (time <= 0L) {
            throw new IOException("invalid key");
        }
        long pos = this.timeBlockHash().get(time);
        while (pos > 0L) {
            long prevPos = this.keyFile().getPrevPos(pos);
            if (prevPos == 0L) {
                return this.keyFile().getDataPos(pos);
            }
            pos = prevPos;
        }
        return null;
    }

    private byte[] getDataPosLast(long _stime, long _etime) {
        if (_etime <= 0L || _stime <= 0L) {
            throw new IOException("invalid key");
        }
        long etime = _etime;
        byte[] dataPos = this.getDataPosLast(etime);
        for (int i = 0; dataPos == null && i < 172800 && _stime <= etime; ++i) {
            dataPos = this.getDataPosLast(etime -= 500L);
        }
        return dataPos;
    }

    private byte[] getDataPosLast(long time) {
        if (time <= 0L) {
            throw new IOException("invalid key");
        }
        long pos = this.timeBlockHash().get(time);
        if (pos == 0L) {
            return null;
        }
        return this.keyFile().getDataPos(pos);
    }

    public Tuple2<byte[], byte[]> getStartEndDataPos(long stime, long etime) {
        byte[] startDataPos = this.getDataPosFirst(stime, etime);
        byte[] endDataPos = this.getDataPosLast(stime, etime);
        return new Tuple2((Object)startDataPos, (Object)endDataPos);
    }

    public TimeToData getDirect(long pos) {
        if (!this.keyFile().isDeleted(pos)) {
            ITEM m = this.keyFile().getRecord(pos);
            return new TimeToData(DataInputX.toLong(m.timeKey(), 0), m.dataPos());
        }
        return null;
    }

    public int delete(long time) {
        if (time <= 0L) {
            throw new IOException("invalid key");
        }
        IndexTimeFile indexTimeFile = this;
        synchronized (indexTimeFile) {
            long pos = this.timeBlockHash().get(time);
            int deleted = 0;
            while (pos > 0L) {
                if (!this.keyFile().isDeleted(pos)) {
                    this.keyFile().setDelete(pos, true);
                    ++deleted;
                }
                pos = this.keyFile().getPrevPos(pos);
            }
            this.timeBlockHash().put(time, 0L);
            this.timeBlockHash().addCount(-deleted);
            return deleted;
        }
    }

    public void read(long _stime, long etime, Function2<Object, byte[], Object> handler) {
        if (this.keyFile() == null) {
            return;
        }
        int i = 0;
        for (long stime = _stime; i < 172800 && stime <= etime; ++i, stime += 500L) {
            ArrayList<TimeToData> data = this.getSecAll(stime);
            EnumerScala$.MODULE$.forward(data, new Serializable(this, handler){
                public static final long serialVersionUID = 0L;
                private final Function2 handler$3;

                public final Object apply(TimeToData timeToData) {
                    return this.handler$3.apply((Object)BoxesRunTime.boxToLong((long)timeToData.time()), (Object)timeToData.dataPos());
                }
                {
                    this.handler$3 = handler$3;
                }
            });
        }
    }

    public void readFromEnd(long stime, long _etime, Function2<Object, byte[], Object> handler) {
        if (this.keyFile() == null) {
            return;
        }
        int i = 0;
        for (long etime = _etime; i < 172800 && stime <= etime; ++i, etime -= 500L) {
            ArrayList<TimeToData> data = this.getSecAll(etime);
            EnumerScala$.MODULE$.backward(data, new Serializable(this, handler){
                public static final long serialVersionUID = 0L;
                private final Function2 handler$5;

                public final Object apply(TimeToData tv) {
                    return this.handler$5.apply((Object)BoxesRunTime.boxToLong((long)tv.time()), (Object)tv.dataPos());
                }
                {
                    this.handler$5 = handler$5;
                }
            });
        }
    }

    public void read(long _stime, long etime, Function2<Object, byte[], Object> handler, Function1<Object, byte[]> reader) {
        if (this.keyFile() == null) {
            return;
        }
        int i = 0;
        for (long stime = _stime; i < 172800 && stime <= etime; ++i, stime += 500L) {
            ArrayList<TimeToData> data = this.getSecAll(stime);
            EnumerScala$.MODULE$.forward(data, new Serializable(this, _stime, etime, handler, reader){
                public static final long serialVersionUID = 0L;
                private final long _stime$1;
                private final long etime$2;
                private final Function2 handler$2;
                private final Function1 reader$2;

                public final Object apply(TimeToData tv) {
                    return tv.time() >= this._stime$1 && tv.time() <= this.etime$2 ? this.handler$2.apply((Object)BoxesRunTime.boxToLong((long)tv.time()), this.reader$2.apply((Object)BoxesRunTime.boxToLong((long)DataInputX.toLong5(tv.dataPos(), 0)))) : BoxedUnit.UNIT;
                }
                {
                    this._stime$1 = _stime$1;
                    this.etime$2 = etime$2;
                    this.handler$2 = handler$2;
                    this.reader$2 = reader$2;
                }
            });
        }
    }

    public void readByLimitCount(long stime, long etime, long lastBucketTime, int limitCount, Function2<Object, byte[], Object> handler, Function1<Object, byte[]> reader) {
        NonLocalReturnControl nonLocalReturnControl2;
        block4: {
            Object object = new Object();
            try {
                if (this.keyFile() == null) {
                    return;
                }
                LongRef timeBucketTime = LongRef.create((long)(lastBucketTime != 0L ? lastBucketTime : stime));
                IntRef counted = IntRef.create((int)0);
                int timeBucketCount = 0;
                while (timeBucketCount < 172800 && timeBucketTime.elem <= etime) {
                    ((List)this.getSecAllV2(timeBucketTime.elem).filter((Function1)new Serializable(this, stime, etime){
                        public static final long serialVersionUID = 0L;
                        private final long stime$1;
                        private final long etime$1;

                        public final boolean apply(TimeToData tv) {
                            return tv.time() >= this.stime$1 && tv.time() <= this.etime$1;
                        }
                        {
                            this.stime$1 = stime$1;
                            this.etime$1 = etime$1;
                        }
                    })).foreach((Function1)new Serializable(this, limitCount, handler, reader, timeBucketTime, counted, object){
                        public static final long serialVersionUID = 0L;
                        private final int limitCount$1;
                        private final Function2 handler$1;
                        private final Function1 reader$1;
                        private final LongRef timeBucketTime$1;
                        private final IntRef counted$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(TimeToData tv) {
                            if (this.counted$1.elem > this.limitCount$1) {
                                throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                            }
                            this.counted$1.elem = BoxesRunTime.unboxToInt((Object)this.handler$1.apply((Object)BoxesRunTime.boxToLong((long)this.timeBucketTime$1.elem), this.reader$1.apply((Object)BoxesRunTime.boxToLong((long)DataInputX.toLong5(tv.dataPos(), 0)))));
                        }
                        {
                            this.limitCount$1 = limitCount$1;
                            this.handler$1 = handler$1;
                            this.reader$1 = reader$1;
                            this.timeBucketTime$1 = timeBucketTime$1;
                            this.counted$1 = counted$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    ++timeBucketCount;
                    timeBucketTime.elem += 500L;
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block4;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void readFromEnd(long stime, long _etime, Function2<Object, byte[], Object> handler, Function1<Object, byte[]> reader) {
        if (this.keyFile() == null) {
            return;
        }
        int i = 0;
        for (long etime = _etime; i < 172800 && stime <= etime; ++i, etime -= 500L) {
            ArrayList<TimeToData> data = this.getSecAll(etime);
            EnumerScala$.MODULE$.backward(data, new Serializable(this, stime, _etime, handler, reader){
                public static final long serialVersionUID = 0L;
                private final long stime$2;
                private final long _etime$1;
                private final Function2 handler$4;
                private final Function1 reader$3;

                public final Object apply(TimeToData tv) {
                    return tv.time() >= this.stime$2 && tv.time() <= this._etime$1 ? this.handler$4.apply((Object)BoxesRunTime.boxToLong((long)tv.time()), this.reader$3.apply((Object)BoxesRunTime.boxToLong((long)DataInputX.toLong5(tv.dataPos(), 0)))) : BoxedUnit.UNIT;
                }
                {
                    this.stime$2 = stime$2;
                    this._etime$1 = _etime$1;
                    this.handler$4 = handler$4;
                    this.reader$3 = reader$3;
                }
            });
        }
    }

    public void read(Function2<byte[], byte[], Object> handler) {
        if (this.keyFile() == null) {
            return;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length) {
                ITEM r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() ? handler.apply((Object)r.timeKey(), (Object)r.dataPos()) : BoxedUnit.UNIT;
                ++done;
                pos = r.offset();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S127", new StringBuilder().append((Object)this.keyFile().path()).append((Object)" : read=").append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
    }

    @Override
    public void close() {
        this.timeBlockHash().close();
        this.keyFile().close();
    }

    public IndexTimeFile(String _path) {
        this.path = _path;
        this.timeBlockHash = new MemTimeBlock(_path);
        this.keyFile = new RealKeyFile(_path);
    }

    public class TimeToData
    implements Comparable<TimeToData> {
        private final long time;
        private final byte[] dataPos;

        public long time() {
            return this.time;
        }

        public byte[] dataPos() {
            return this.dataPos;
        }

        @Override
        public int compareTo(TimeToData t) {
            long v = this.time() - t.time();
            if (v == 0L) {
                return CompareUtil.compareTo(this.dataPos(), t.dataPos());
            }
            return v > 0L ? 1 : -1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TimeToData) {
                return this.compareTo((TimeToData)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.time();
        }

        public String toString() {
            return new StringBuilder().append((Object)DateUtil.timestamp(this.time())).append((Object)" byte[").append((Object)BoxesRunTime.boxToInteger((int)BytesUtil.getLength(this.dataPos()))).append((Object)"]").toString();
        }

        public /* synthetic */ IndexTimeFile scouter$server$db$io$IndexTimeFile$TimeToData$$$outer() {
            return IndexTimeFile.this;
        }

        public TimeToData(long _time, byte[] _dataPos) {
            if (IndexTimeFile.this == null) {
                throw null;
            }
            this.time = _time;
            this.dataPos = _dataPos;
        }
    }
}

