/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.io.FlushCtr;
import scouter.io.IFlushable;
import scouter.util.FileUtil;

public class MemHashBlock
implements IFlushable {
    private static final int _countPos = 4;
    private static final int _memHeadReserved = 1024;
    private static final int _keyLength = 5;
    protected File file;
    protected byte[] memBuffer;
    protected int memBufferSize;
    protected String path;
    protected int count;
    protected int capacity;
    private boolean dirty;

    public MemHashBlock(String path, int memSize) throws IOException {
        this.open(path, memSize);
    }

    @Override
    public synchronized void flush() {
        FileUtil.save(this.file, this.memBuffer);
        this.dirty = false;
    }

    @Override
    public long interval() {
        return 4000L;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    private void open(String path, int memSize) throws FileNotFoundException, IOException {
        boolean isNew;
        this.path = path;
        this.memBufferSize = memSize;
        this.file = new File(this.path + ".hfile");
        boolean bl = isNew = !this.file.exists() || this.file.length() < 1024L;
        if (isNew) {
            this.memBuffer = new byte[1024 + this.memBufferSize];
            this.memBuffer[0] = -54;
            this.memBuffer[1] = -2;
        } else {
            this.memBufferSize = (int)(this.file.length() - 1024L);
            this.memBuffer = FileUtil.readAll(this.file);
            this.count = DataInputX.toInt(this.memBuffer, 4);
        }
        this.capacity = this.memBufferSize / 5;
        FlushCtr.getInstance().regist(this);
    }

    private int _offset(int keyHash) {
        int bucketPos = (keyHash & Integer.MAX_VALUE) % this.capacity;
        return 5 * bucketPos + 1024;
    }

    public synchronized long get(int keyHash) throws IOException {
        int pos = this._offset(keyHash);
        return DataInputX.toLong5(this.memBuffer, pos);
    }

    public int getCount() {
        return this.count;
    }

    private int addCount(int n) throws IOException {
        this.count += n;
        DataOutputX.set(this.memBuffer, 4, DataOutputX.toBytes(this.count));
        return this.count;
    }

    public synchronized void put(int keyHash, long value) throws IOException {
        byte[] buffer = DataOutputX.toBytes5(value);
        int pos = this._offset(keyHash);
        if (DataInputX.toLong5(this.memBuffer, pos) == 0L) {
            this.addCount(1);
        }
        System.arraycopy(buffer, 0, this.memBuffer, pos, 5);
        this.dirty = true;
    }

    public void close() {
        FlushCtr.getInstance().unregist(this);
    }
}

