/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.io.FlushCtr;
import scouter.io.IFlushable;
import scouter.util.DateUtil;
import scouter.util.FileUtil;

public class MemTimeBlock
implements IFlushable {
    private static final int _countPos = 4;
    protected File file;
    protected static final int _memHeadReserved = 1024;
    protected static final int _keyLength = 5;
    protected int memBufferSize = 864000;
    protected byte[] memBuffer;
    protected String path;
    protected final int capacity = 172800;
    private int count;
    private boolean dirty;

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public long interval() {
        return 4000L;
    }

    public MemTimeBlock(String path) throws IOException {
        this.open(path);
    }

    private void open(String path) throws FileNotFoundException, IOException {
        boolean isNew;
        this.path = path;
        this.file = new File(this.path + ".hfile");
        boolean bl = isNew = !this.file.exists() || this.file.length() < 1024L;
        if (isNew) {
            this.memBuffer = new byte[1024 + this.memBufferSize];
            this.memBuffer[0] = -54;
            this.memBuffer[1] = -2;
        } else {
            this.memBufferSize = (int)(this.file.length() - 1024L);
            this.memBuffer = FileUtil.readAll(this.file);
            this.count = DataInputX.toInt(this.memBuffer, 4);
        }
        FlushCtr.getInstance().regist(this);
    }

    private int _offset(long time) {
        int seconds = DateUtil.getDateMillis(time) / 500;
        int hash = seconds % 172800;
        return 5 * hash + 1024;
    }

    @Override
    public synchronized void flush() {
        FileUtil.save(this.file, this.memBuffer);
        this.dirty = false;
    }

    public synchronized long get(long time) throws IOException {
        int pos = this._offset(time);
        return DataInputX.toLong5(this.memBuffer, pos);
    }

    public int getCount() {
        return this.count;
    }

    public int addCount(int n) {
        this.count += n;
        DataOutputX.set(this.memBuffer, 4, DataOutputX.toBytes(this.count));
        return this.count;
    }

    public synchronized void put(long time, long value) throws IOException {
        byte[] buffer = DataOutputX.toBytes5(value);
        int pos = this._offset(time);
        if (DataInputX.toLong5(this.memBuffer, pos) == 0L) {
            this.addCount(1);
        }
        System.arraycopy(buffer, 0, this.memBuffer, pos, 5);
        this.dirty = true;
    }

    public void close() {
        FlushCtr.getInstance().unregist(this);
    }
}

