/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io.zip;

public class Block {
    public String date;
    public int blockNum;
    private byte[] buf;
    public final int START;
    public int END;
    public final int MAX;
    public boolean dirty;
    public long lastAccessTime;

    public Block(String date) {
        this(date, 0x2000000);
    }

    public Block(String date, int max) {
        this(date, new byte[128], 0, 0, max);
    }

    public Block(String date, byte[] buf, int max) {
        this(date, buf, 0, buf.length, max);
    }

    public Block(String date, byte[] buf, int start, int end, int max) {
        this.date = date;
        this.buf = buf;
        this.START = start;
        this.END = end;
        this.MAX = max;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buf.length) {
            int oldCapacity = this.buf.length;
            int newCapacity = oldCapacity << 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            newCapacity = Math.min(newCapacity, this.MAX);
            this.buf = Block.copyOf(this.buf, newCapacity);
        }
    }

    private static byte[] copyOf(byte[] org, int length) {
        byte[] copy2 = new byte[length];
        System.arraycopy(org, 0, copy2, 0, Math.min(org.length, length));
        return copy2;
    }

    public boolean write(byte[] b) {
        return this.write(b, 0, b.length);
    }

    public synchronized boolean write(byte[] b, int offset, int len) {
        if (this.END + len > this.MAX) {
            return false;
        }
        this.ensureCapacity(this.END - this.START + len);
        System.arraycopy(b, offset, this.buf, this.END - this.START, len);
        this.END += len;
        this.dirty = true;
        return true;
    }

    public synchronized byte[] read(long pos, int len) {
        if (len <= 0) {
            return null;
        }
        int bpos = (int)(pos - (long)(this.blockNum * 0x2000000));
        if (len + bpos > this.END) {
            return null;
        }
        if (bpos < this.START) {
            return null;
        }
        byte[] out = new byte[len];
        System.arraycopy(this.buf, bpos - this.START, out, 0, len);
        return out;
    }

    public long getOffset() {
        return (long)this.END + (long)this.blockNum * 0x2000000L;
    }

    public byte[] getBlockBytes() {
        byte[] out = new byte[this.END - this.START];
        System.arraycopy(this.buf, 0, out, 0, this.END - this.START);
        return out;
    }

    public Block createNextBlock() {
        Block bk = new Block(this.date, this.MAX);
        bk.blockNum = this.blockNum + 1;
        return bk;
    }

    public boolean readable(long pos) {
        int bpos = (int)(pos - (long)(this.blockNum * 0x2000000));
        if (8 + bpos > this.END) {
            return false;
        }
        return bpos >= this.START;
    }

    public Block merge(Block old) {
        int start = Math.min(this.START, old.START);
        int end = Math.max(this.END, old.END);
        byte[] block = new byte[end - start];
        System.arraycopy(this.buf, 0, block, this.START - start, this.END - this.START);
        System.arraycopy(old.buf, 0, block, old.START - start, old.END - old.START);
        Block b = new Block(this.date, block, start, end, this.MAX);
        b.blockNum = this.blockNum;
        return b;
    }

    public String toString() {
        return "Block [date=" + this.date + ", blockNum=" + this.blockNum + ", START=" + this.START + ", END=" + this.END + ", MAX=" + this.MAX + ", dirty=" + this.dirty + "]";
    }
}

