/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.xlog;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.db.io.zip.GZipStore;
import scouter.server.db.xlog.XLogDataReader$;
import scouter.util.FileUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005Mr!B\u0001\u0003\u0011\u0003Y\u0011A\u0004-M_\u001e$\u0015\r^1SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\tA\u0001\u001f7pO*\u0011QAB\u0001\u0003I\nT!a\u0002\u0005\u0002\rM,'O^3s\u0015\u0005I\u0011aB:d_V$XM]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u00059AFj\\4ECR\f'+Z1eKJ\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011A\u000e\u0002\u000bQ\f'\r\\3\u0016\u0003q\u0001B!\b\u0012%W5\taD\u0003\u0002 A\u0005!Q\u000f^5m\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\u0013!\u000b7\u000f\u001b;bE2,\u0007CA\u0013)\u001d\t\tb%\u0003\u0002(%\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9#\u0003\u0005\u0002\rY\u0019!aB\u0001\u0001.'\rac\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\nA\u0001\\1oO&\u00111\u0007\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U:T\"\u0001\u001c\u000b\u0005}A\u0011B\u0001\u001d7\u0005\u0019I5\t\\8tK\"A!\b\fB\u0001B\u0003%A%\u0001\u0003eCR,\u0007\u0002\u0003\u001f-\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\t\u0019LG.\u001a\u0005\u0006/1\"\tA\u0010\u000b\u0004W}\u0002\u0005\"\u0002\u001e>\u0001\u0004!\u0003\"\u0002\u001f>\u0001\u0004!\u0003b\u0002\"-\u0001\u0004%\taQ\u0001\ne\u00164WM]3oG\u0016,\u0012\u0001\u0012\t\u0003#\u0015K!A\u0012\n\u0003\u0007%sG\u000fC\u0004IY\u0001\u0007I\u0011A%\u0002\u001bI,g-\u001a:f]\u000e,w\fJ3r)\tQU\n\u0005\u0002\u0012\u0017&\u0011AJ\u0005\u0002\u0005+:LG\u000fC\u0004O\u000f\u0006\u0005\t\u0019\u0001#\u0002\u0007a$\u0013\u0007\u0003\u0004QY\u0001\u0006K\u0001R\u0001\u000be\u00164WM]3oG\u0016\u0004\u0003b\u0002*-\u0005\u0004%\taU\u0001\u0005G>tg-F\u0001U!\t)f+D\u0001\u0007\u0013\t9fAA\u0005D_:4\u0017nZ;sK\"1\u0011\f\fQ\u0001\nQ\u000bQaY8oM\u0002Bqa\u0017\u0017A\u0002\u0013\u0005A,A\u0005q_&tGOR5mKV\tQ\f\u0005\u0002_C6\tqL\u0003\u0002aA\u0005\u0011\u0011n\\\u0005\u0003E~\u0013\u0001CU1oI>l\u0017iY2fgN4\u0015\u000e\\3\t\u000f\u0011d\u0003\u0019!C\u0001K\u0006i\u0001o\\5oi\u001aKG.Z0%KF$\"A\u00134\t\u000f9\u001b\u0017\u0011!a\u0001;\"1\u0001\u000e\fQ!\nu\u000b!\u0002]8j]R4\u0015\u000e\\3!\u0011\u001dQG\u00061A\u0005\u0002-\fAa\u001a>jaV\tA\u000e\u0005\u0002\u0012[&\u0011aN\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\u0001H\u00061A\u0005\u0002E\f\u0001b\u001a>ja~#S-\u001d\u000b\u0003\u0015JDqAT8\u0002\u0002\u0003\u0007A\u000e\u0003\u0004uY\u0001\u0006K\u0001\\\u0001\u0006OjL\u0007\u000f\t\u0005\bm2\u0012\r\u0011\"\u0001x\u0003!\u0019wN\u001c4GS2,W#\u0001=\u0011\u0005yK\u0018B\u0001>`\u0005\u00111\u0015\u000e\\3\t\rqd\u0003\u0015!\u0003y\u0003%\u0019wN\u001c4GS2,\u0007\u0005C\u0004\u007fY\t\u0007I\u0011A<\u0002\u0011adwn\u001a$jY\u0016Dq!!\u0001-A\u0003%\u00010A\u0005yY><g)\u001b7fA!9\u0011Q\u0001\u0017\u0005\u0002\u0005\u001d\u0011\u0001\u0002:fC\u0012$B!!\u0003\u0002\u0016A)\u0011#a\u0003\u0002\u0010%\u0019\u0011Q\u0002\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0007E\t\t\"C\u0002\u0002\u0014I\u0011AAQ=uK\"A\u0011qCA\u0002\u0001\u0004\tI\"A\u0003q_&tG\u000fE\u0002\u0012\u00037I1!!\b\u0013\u0005\u0011auN\\4\t\u000f\u0005\u0005B\u0006\"\u0011\u0002$\u0005)1\r\\8tKR\t!\nC\u0004\u0002(5\u0001\u000b\u0011\u0002\u000f\u0002\rQ\f'\r\\3!\u0011\u001d\tY#\u0004C\u0001\u0003[\tAa\u001c9f]R)1&a\f\u00022!1!(!\u000bA\u0002\u0011Ba\u0001PA\u0015\u0001\u0004!\u0003")
public class XLogDataReader
implements IClose {
    private final String date;
    private final String file;
    private int reference;
    private final Configure conf;
    private RandomAccessFile pointFile;
    private boolean gzip;
    private final File confFile;
    private final File xlogFile;

    public static XLogDataReader open(String string, String string2) {
        return XLogDataReader$.MODULE$.open(string, string2);
    }

    public static Hashtable<String, XLogDataReader> table() {
        return XLogDataReader$.MODULE$.table();
    }

    public int reference() {
        return this.reference;
    }

    public void reference_$eq(int x$1) {
        this.reference = x$1;
    }

    public Configure conf() {
        return this.conf;
    }

    public RandomAccessFile pointFile() {
        return this.pointFile;
    }

    public void pointFile_$eq(RandomAccessFile x$1) {
        this.pointFile = x$1;
    }

    public boolean gzip() {
        return this.gzip;
    }

    public void gzip_$eq(boolean x$1) {
        this.gzip = x$1;
    }

    public File confFile() {
        return this.confFile;
    }

    public File xlogFile() {
        return this.xlogFile;
    }

    public byte[] read(long point) {
        if (this.gzip()) {
            return GZipStore.getInstance().read(this.date, point);
        }
        if (this.pointFile() == null) {
            return null;
        }
        try {
            XLogDataReader xLogDataReader = this;
            synchronized (xLogDataReader) {
                this.pointFile().seek(point);
                short len = this.pointFile().readShort();
                byte[] buffer = new byte[len];
                this.pointFile().read(buffer);
                return buffer;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void close() {
        Hashtable<String, XLogDataReader> hashtable = XLogDataReader$.MODULE$.table();
        synchronized (hashtable) {
            BoxedUnit boxedUnit;
            if (this.reference() == 0) {
                XLogDataReader$.MODULE$.table().remove(this.file);
                this.pointFile_$eq(FileUtil.close(this.pointFile()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.reference_$eq(this.reference() - 1);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public XLogDataReader(String date, String file) {
        this.date = date;
        this.file = file;
        this.reference = 0;
        this.conf = Configure.getInstance();
        this.pointFile = null;
        this.gzip = this.conf().compress_xlog_enabled;
        this.confFile = new File(new StringBuilder().append((Object)file).append((Object)".service.conf").toString());
        if (this.confFile().exists()) {
            Properties properties = FileUtil.readProperties(this.confFile());
            this.gzip_$eq("true".equalsIgnoreCase(properties.getProperty("compress_xlog_enabled", String.valueOf(BoxesRunTime.boxToBoolean((boolean)this.conf().compress_xlog_enabled))).trim()));
        }
        this.xlogFile = new File(new StringBuilder().append((Object)file).append((Object)".service").toString());
        if (this.xlogFile().canRead()) {
            this.pointFile_$eq(new RandomAccessFile(this.xlogFile(), "r"));
        }
    }
}

