/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.xlog;

import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.db.io.RealDataFile;
import scouter.server.db.io.zip.GZipStore;
import scouter.server.db.xlog.XLogDataWriter$;
import scouter.util.FileUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005]r!B\u0001\u0003\u0011\u0003Y\u0011A\u0004-M_\u001e$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u0007\u0011\tA\u0001\u001f7pO*\u0011QAB\u0001\u0003I\nT!a\u0002\u0005\u0002\rM,'O^3s\u0015\u0005I\u0011aB:d_V$XM]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u00059AFj\\4ECR\fwK]5uKJ\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011A\u000e\u0002\u000bQ\f'\r\\3\u0016\u0003q\u0001B!\b\u0012%W5\taD\u0003\u0002 A\u0005!Q\u000f^5m\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\u0013!\u000b7\u000f\u001b;bE2,\u0007CA\u0013)\u001d\t\tb%\u0003\u0002(%\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9#\u0003\u0005\u0002\rY\u0019!aB\u0001\u0001.'\rac\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\nA\u0001\\1oO&\u00111\u0007\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U:T\"\u0001\u001c\u000b\u0005}A\u0011B\u0001\u001d7\u0005\u0019I5\t\\8tK\"A!\b\fB\u0001B\u0003%A%\u0001\u0003eCR,\u0007\u0002\u0003\u001f-\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\t\u0019LG.\u001a\u0005\u0006/1\"\tA\u0010\u000b\u0004W}\u0002\u0005\"\u0002\u001e>\u0001\u0004!\u0003\"\u0002\u001f>\u0001\u0004!\u0003b\u0002\"-\u0001\u0004%\taQ\u0001\ne\u00164WM]3oG\u0016,\u0012\u0001\u0012\t\u0003#\u0015K!A\u0012\n\u0003\u0007%sG\u000fC\u0004IY\u0001\u0007I\u0011A%\u0002\u001bI,g-\u001a:f]\u000e,w\fJ3r)\tQU\n\u0005\u0002\u0012\u0017&\u0011AJ\u0005\u0002\u0005+:LG\u000fC\u0004O\u000f\u0006\u0005\t\u0019\u0001#\u0002\u0007a$\u0013\u0007\u0003\u0004QY\u0001\u0006K\u0001R\u0001\u000be\u00164WM]3oG\u0016\u0004\u0003b\u0002*-\u0005\u0004%\taU\u0001\u0005G>tg-F\u0001U!\t)f+D\u0001\u0007\u0013\t9fAA\u0005D_:4\u0017nZ;sK\"1\u0011\f\fQ\u0001\nQ\u000bQaY8oM\u0002Bqa\u0017\u0017A\u0002\u0013\u0005A,\u0001\u0003hu&\u0004X#A/\u0011\u0005Eq\u0016BA0\u0013\u0005\u001d\u0011un\u001c7fC:Dq!\u0019\u0017A\u0002\u0013\u0005!-\u0001\u0005hu&\u0004x\fJ3r)\tQ5\rC\u0004OA\u0006\u0005\t\u0019A/\t\r\u0015d\u0003\u0015)\u0003^\u0003\u00159'0\u001b9!\u0011\u001d9G\u00061A\u0005\u0002!\f\u0011AZ\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011A\u000eI\u0001\u0003S>L!A\\6\u0003\t\u0019KG.\u001a\u0005\ba2\u0002\r\u0011\"\u0001r\u0003\u00151w\fJ3r)\tQ%\u000fC\u0004O_\u0006\u0005\t\u0019A5\t\rQd\u0003\u0015)\u0003j\u0003\t1\u0007\u0005C\u0004wY\u0001\u0007I\u0011A<\u0002\u0007=,H/F\u0001y!\tI80D\u0001{\u0015\taG!\u0003\u0002}u\na!+Z1m\t\u0006$\u0018MR5mK\"9a\u0010\fa\u0001\n\u0003y\u0018aB8vi~#S-\u001d\u000b\u0004\u0015\u0006\u0005\u0001b\u0002(~\u0003\u0003\u0005\r\u0001\u001f\u0005\b\u0003\u000ba\u0003\u0015)\u0003y\u0003\u0011yW\u000f\u001e\u0011\t\u000f\u0005%A\u0006\"\u0001\u0002\f\u0005)qO]5uKR!\u0011QBA\n!\r\t\u0012qB\u0005\u0004\u0003#\u0011\"\u0001\u0002'p]\u001eD\u0001\"!\u0006\u0002\b\u0001\u0007\u0011qC\u0001\u0006Ef$Xm\u001d\t\u0006#\u0005e\u0011QD\u0005\u0004\u00037\u0011\"!B!se\u0006L\bcA\t\u0002 %\u0019\u0011\u0011\u0005\n\u0003\t\tKH/\u001a\u0005\b\u0003KaC\u0011IA\u0014\u0003\u0015\u0019Gn\\:f)\u0005Q\u0005bBA\u0016\u001b\u0001\u0006I\u0001H\u0001\u0007i\u0006\u0014G.\u001a\u0011\t\u000f\u0005=R\u0002\"\u0001\u00022\u0005!q\u000e]3o)\u0015Y\u00131GA\u001b\u0011\u0019Q\u0014Q\u0006a\u0001I!1A(!\fA\u0002\u0011\u0002")
public class XLogDataWriter
implements IClose {
    private final String date;
    private final String file;
    private int reference;
    private final Configure conf;
    private boolean gzip;
    private File f;
    private RealDataFile out;

    public static XLogDataWriter open(String string, String string2) {
        return XLogDataWriter$.MODULE$.open(string, string2);
    }

    public static Hashtable<String, XLogDataWriter> table() {
        return XLogDataWriter$.MODULE$.table();
    }

    public int reference() {
        return this.reference;
    }

    public void reference_$eq(int x$1) {
        this.reference = x$1;
    }

    public Configure conf() {
        return this.conf;
    }

    public boolean gzip() {
        return this.gzip;
    }

    public void gzip_$eq(boolean x$1) {
        this.gzip = x$1;
    }

    public File f() {
        return this.f;
    }

    public void f_$eq(File x$1) {
        this.f = x$1;
    }

    public RealDataFile out() {
        return this.out;
    }

    public void out_$eq(RealDataFile x$1) {
        this.out = x$1;
    }

    public long write(byte[] bytes) {
        if (this.gzip()) {
            return GZipStore.getInstance().write(this.date, bytes);
        }
        XLogDataWriter xLogDataWriter = this;
        synchronized (xLogDataWriter) {
            long point = this.out().getOffset();
            this.out().writeShort((short)bytes.length);
            this.out().write(bytes);
            this.out().flush();
            return point;
        }
    }

    @Override
    public void close() {
        Hashtable<String, XLogDataWriter> hashtable = XLogDataWriter$.MODULE$.table();
        synchronized (hashtable) {
            Object object;
            if (this.reference() == 0) {
                XLogDataWriter$.MODULE$.table().remove(this.file);
                object = FileUtil.close(this.out());
            } else {
                this.reference_$eq(this.reference() - 1);
                object = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public XLogDataWriter(String date, String file) {
        this.date = date;
        this.file = file;
        this.reference = 0;
        this.conf = Configure.getInstance();
        this.gzip = this.conf().compress_xlog_enabled;
        this.f = new File(new StringBuilder().append((Object)file).append((Object)".service.conf").toString());
        if (this.f().exists()) {
            Properties properties = FileUtil.readProperties(this.f());
            this.gzip_$eq("true".equalsIgnoreCase(properties.getProperty("compress_xlog_enabled", String.valueOf(BoxesRunTime.boxToBoolean((boolean)this.conf().compress_xlog_enabled))).trim()));
        } else {
            this.gzip_$eq(this.conf().compress_xlog_enabled);
            Properties properties = new Properties();
            properties.put("compress_xlog_enabled", String.valueOf(BoxesRunTime.boxToBoolean((boolean)this.conf().compress_xlog_enabled)));
            FileUtil.writeProperties(this.f(), properties);
        }
        this.out = null;
        if (!this.gzip()) {
            this.out_$eq(new RealDataFile(new StringBuilder().append((Object)file).append((Object)".service").toString()));
        }
    }
}

