/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.xlog;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.db.io.zip.GZipStore;
import scouter.server.db.xlog.XLogProfileDataReader$;
import scouter.util.FileUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005Mr!B\u0001\u0003\u0011\u0003Y\u0011!\u0006-M_\u001e\u0004&o\u001c4jY\u0016$\u0015\r^1SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\tA\u0001\u001f7pO*\u0011QAB\u0001\u0003I\nT!a\u0002\u0005\u0002\rM,'O^3s\u0015\u0005I\u0011aB:d_V$XM]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005UAFj\\4Qe>4\u0017\u000e\\3ECR\f'+Z1eKJ\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011A\u000e\u0002\u000bQ\f'\r\\3\u0016\u0003q\u0001B!\b\u0012%W5\taD\u0003\u0002 A\u0005!Q\u000f^5m\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\u0013!\u000b7\u000f\u001b;bE2,\u0007CA\u0013)\u001d\t\tb%\u0003\u0002(%\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9#\u0003\u0005\u0002\rY\u0019!aB\u0001\u0001.'\rac\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\nA\u0001\\1oO&\u00111\u0007\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U:T\"\u0001\u001c\u000b\u0005}A\u0011B\u0001\u001d7\u0005\u0019I5\t\\8tK\"A!\b\fB\u0001B\u0003%A%\u0001\u0003eCR,\u0007\u0002\u0003\u001f-\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\t\u0019LG.\u001a\u0005\u0006/1\"\tA\u0010\u000b\u0004W}\u0002\u0005\"\u0002\u001e>\u0001\u0004!\u0003\"\u0002\u001f>\u0001\u0004!\u0003b\u0002\"-\u0001\u0004%\taQ\u0001\te\u00164'/\u001a8dKV\tA\t\u0005\u0002\u0012\u000b&\u0011aI\u0005\u0002\u0004\u0013:$\bb\u0002%-\u0001\u0004%\t!S\u0001\re\u00164'/\u001a8dK~#S-\u001d\u000b\u0003\u00156\u0003\"!E&\n\u00051\u0013\"\u0001B+oSRDqAT$\u0002\u0002\u0003\u0007A)A\u0002yIEBa\u0001\u0015\u0017!B\u0013!\u0015!\u0003:fMJ,gnY3!\u0011\u001d\u0011FF1A\u0005\u0002M\u000bAaY8oMV\tA\u000b\u0005\u0002V-6\ta!\u0003\u0002X\r\tI1i\u001c8gS\u001e,(/\u001a\u0005\u000732\u0002\u000b\u0011\u0002+\u0002\u000b\r|gN\u001a\u0011\t\u000fmc\u0003\u0019!C\u00059\u0006Y\u0001O]8gS2,g)\u001b7f+\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011!\u0003\tIw.\u0003\u0002c?\n\u0001\"+\u00198e_6\f5mY3tg\u001aKG.\u001a\u0005\bI2\u0002\r\u0011\"\u0003f\u0003=\u0001(o\u001c4jY\u00164\u0015\u000e\\3`I\u0015\fHC\u0001&g\u0011\u001dq5-!AA\u0002uCa\u0001\u001b\u0017!B\u0013i\u0016\u0001\u00049s_\u001aLG.\u001a$jY\u0016\u0004\u0003b\u00026-\u0001\u0004%Ia[\u0001\u0005OjL\u0007/F\u0001m!\t\tR.\u0003\u0002o%\t9!i\\8mK\u0006t\u0007b\u00029-\u0001\u0004%I!]\u0001\tOjL\u0007o\u0018\u0013fcR\u0011!J\u001d\u0005\b\u001d>\f\t\u00111\u0001m\u0011\u0019!H\u0006)Q\u0005Y\u0006)qM_5qA!9a\u000f\fb\u0001\n\u00039\u0018\u0001C2p]\u001a4\u0015\u000e\\3\u0016\u0003a\u0004\"AX=\n\u0005i|&\u0001\u0002$jY\u0016Da\u0001 \u0017!\u0002\u0013A\u0018!C2p]\u001a4\u0015\u000e\\3!\u0011\u001dqHF1A\u0005\u0002]\fq\u0001\u001d:pM&dW\rC\u0004\u0002\u00021\u0002\u000b\u0011\u0002=\u0002\u0011A\u0014xNZ5mK\u0002Bq!!\u0002-\t\u0003\t9!\u0001\u0003sK\u0006$G\u0003BA\u0005\u0003+\u0001R!EA\u0006\u0003\u001fI1!!\u0004\u0013\u0005\u0015\t%O]1z!\r\t\u0012\u0011C\u0005\u0004\u0003'\u0011\"\u0001\u0002\"zi\u0016D\u0001\"a\u0006\u0002\u0004\u0001\u0007\u0011\u0011D\u0001\u0004a>\u001c\bcA\t\u0002\u001c%\u0019\u0011Q\u0004\n\u0003\t1{gn\u001a\u0005\b\u0003CaC\u0011IA\u0012\u0003\u0015\u0019Gn\\:f)\u0005Q\u0005bBA\u0014\u001b\u0001\u0006I\u0001H\u0001\u0007i\u0006\u0014G.\u001a\u0011\t\u000f\u0005-R\u0002\"\u0001\u0002.\u0005!q\u000e]3o)\u0015Y\u0013qFA\u0019\u0011\u0019Q\u0014\u0011\u0006a\u0001I!1A(!\u000bA\u0002\u0011\u0002")
public class XLogProfileDataReader
implements IClose {
    private final String date;
    private final String file;
    private int refrence;
    private final Configure conf;
    private RandomAccessFile profileFile;
    private boolean gzip;
    private final File confFile;
    private final File profile;

    public static XLogProfileDataReader open(String string, String string2) {
        return XLogProfileDataReader$.MODULE$.open(string, string2);
    }

    public static Hashtable<String, XLogProfileDataReader> table() {
        return XLogProfileDataReader$.MODULE$.table();
    }

    public int refrence() {
        return this.refrence;
    }

    public void refrence_$eq(int x$1) {
        this.refrence = x$1;
    }

    public Configure conf() {
        return this.conf;
    }

    private RandomAccessFile profileFile() {
        return this.profileFile;
    }

    private void profileFile_$eq(RandomAccessFile x$1) {
        this.profileFile = x$1;
    }

    private boolean gzip() {
        return this.gzip;
    }

    private void gzip_$eq(boolean x$1) {
        this.gzip = x$1;
    }

    public File confFile() {
        return this.confFile;
    }

    public File profile() {
        return this.profile;
    }

    public byte[] read(long pos) {
        if (this.gzip()) {
            return GZipStore.getInstance().read(this.date, pos);
        }
        if (this.profileFile() == null) {
            return null;
        }
        try {
            XLogProfileDataReader xLogProfileDataReader = this;
            synchronized (xLogProfileDataReader) {
                this.profileFile().seek(pos);
                int len = this.profileFile().readInt();
                byte[] buffer = new byte[len];
                this.profileFile().read(buffer);
                return buffer;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void close() {
        Hashtable<String, XLogProfileDataReader> hashtable = XLogProfileDataReader$.MODULE$.table();
        synchronized (hashtable) {
            BoxedUnit boxedUnit;
            if (this.refrence() == 0) {
                XLogProfileDataReader$.MODULE$.table().remove(this.file);
                this.liftedTree1$1();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.refrence_$eq(this.refrence() - 1);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final void liftedTree1$1() {
        try {
            if (this.profileFile() != null) {
                this.profileFile().close();
            }
            this.profileFile_$eq(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public XLogProfileDataReader(String date, String file) {
        this.date = date;
        this.file = file;
        this.refrence = 0;
        this.conf = Configure.getInstance();
        this.profileFile = null;
        this.gzip = this.conf().compress_profile_enabled;
        this.confFile = new File(new StringBuilder().append((Object)file).append((Object)".profile.conf").toString());
        if (this.confFile().exists()) {
            Properties properties = FileUtil.readProperties(this.confFile());
            this.gzip_$eq("true".equalsIgnoreCase(properties.getProperty("compress_profile_enabled", String.valueOf(BoxesRunTime.boxToBoolean((boolean)this.conf().compress_profile_enabled))).trim()));
        }
        this.profile = new File(new StringBuilder().append((Object)file).append((Object)".profile").toString());
        if (this.profile().canRead()) {
            this.profileFile_$eq(new RandomAccessFile(this.profile(), "r"));
        }
    }
}

