/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.http;

import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.http.servlet.CounterServlet;
import scouter.server.http.servlet.RegisterServlet;
import scouter.server.http.servlet.TelegrafInputServlet;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public class HttpServer
extends Thread {
    private static volatile HttpServer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpServer load() {
        if (instance != null) return instance;
        Class<HttpServer> clazz = HttpServer.class;
        synchronized (HttpServer.class) {
            if (instance != null) return instance;
            instance = new HttpServer();
            instance.setName(ThreadUtil.getName(HttpServer.class));
            instance.setDaemon(true);
            instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void run() {
        Configure conf = Configure.getInstance();
        System.setProperty("scouter_webapp_log_dir", conf.log_dir);
        if (conf.net_http_server_enabled) {
            Class<?> c;
            Server server = new Server(conf.net_http_port);
            HandlerCollection handlers = new HandlerCollection();
            NCSARequestLog requestLog = new NCSARequestLog();
            requestLog.setFilename(conf.log_dir + "/http-request-yyyy_mm_dd.log");
            requestLog.setFilenameDateFormat("yyyy_MM_dd");
            requestLog.setRetainDays(conf.log_keep_days);
            requestLog.setAppend(true);
            requestLog.setExtended(true);
            requestLog.setLogCookies(false);
            requestLog.setLogTimeZone(TimeZone.getDefault().getID());
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            ServletContextHandler context = null;
            handlers.addHandler((Handler)requestLogHandler);
            if (conf.net_http_api_enabled) {
                try {
                    c = Class.forName("scouterx.webapp.main.WebAppMain");
                    Object result = c.getMethod("setWebAppContext", new Class[0]).invoke(null, new Object[0]);
                    context = (ServletContextHandler)result;
                }
                catch (Throwable e) {
                    Logger.println("Error while loading webapp api context!");
                    System.out.println("Error while loading webapp api context!");
                    Logger.printStackTrace(e);
                    e.printStackTrace();
                }
            }
            if (context == null) {
                context = new ServletContextHandler(1);
                context.setContextPath("/");
            }
            context.addServlet(new ServletHolder(CounterServlet.class), "/counter/*");
            context.addServlet(new ServletHolder(RegisterServlet.class), "/register/*");
            context.addServlet(new ServletHolder(TelegrafInputServlet.class), "/telegraf/*");
            if (conf.net_http_api_gzip_enabled) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT", "DELETE"});
                gzipHandler.setMinGzipSize(1024);
                gzipHandler.setHandler((Handler)context);
                handlers.addHandler((Handler)gzipHandler);
            } else {
                handlers.addHandler((Handler)context);
            }
            server.setHandler((Handler)handlers);
            if (conf.net_http_api_enabled) {
                try {
                    c = Class.forName("scouterx.webapp.main.WebAppMain");
                    c.getMethod("setWebSocketServer", ServletContextHandler.class).invoke(null, context);
                }
                catch (Throwable e) {
                    Logger.println("Error while setWebSocketServer!");
                    System.out.println("Error while setWebSocketServer!");
                    Logger.printStackTrace(e);
                    e.printStackTrace();
                }
            }
            try {
                server.start();
                server.join();
            }
            catch (Exception e) {
                Logger.println("HTTP", 10, "Failed to start http server", e);
            }
        }
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-FORWARDED-FOR");
        if (ip == null) {
            return request.getRemoteAddr();
        }
        String[] ips = StringUtil.split(ip, ',');
        if (ips.length > 0) {
            return ips[0];
        }
        return request.getRemoteAddr();
    }
}

