/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.data;

import java.net.InetAddress;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.netio.data.MultiPacket;
import scouter.server.util.ThreadScala$;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.ThreadUtil;

public final class MultiPacketProcessor$ {
    public static final MultiPacketProcessor$ MODULE$;
    private final int MAX_COUNT;
    private final LongKeyLinkedMap<MultiPacket> buffer;

    static {
        new MultiPacketProcessor$();
    }

    public int MAX_COUNT() {
        return this.MAX_COUNT;
    }

    public LongKeyLinkedMap<MultiPacket> buffer() {
        return this.buffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] add(long pkid, int total, int num, byte[] data, int objHash, InetAddress addr) {
        MultiPacket p = null;
        LongKeyLinkedMap<MultiPacket> longKeyLinkedMap = this.buffer();
        synchronized (longKeyLinkedMap) {
            Object object;
            p = this.buffer().get(pkid);
            if (p == null) {
                p = new MultiPacket(total, objHash, addr);
                object = this.buffer().put(pkid, p);
            } else {
                object = BoxedUnit.UNIT;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : longKeyLinkedMap
            p.set(num, data);
            if (!p.isDone()) return null;
            this.buffer().remove(pkid);
            return p.toBytes();
        }
    }

    public void checkExpired() {
        LongEnumer en = this.buffer().keys();
        while (en.hasMoreElements()) {
            long key = en.nextLong();
            MultiPacket p = this.buffer().get(key);
            if (!p.isExpired()) continue;
            this.buffer().remove(key);
            if (!Configure.getInstance().log_expired_multipacket) continue;
            Logger$.MODULE$.println("S150", 10, p.toString());
        }
    }

    private MultiPacketProcessor$() {
        MODULE$ = this;
        this.MAX_COUNT = 1000;
        this.buffer = new LongKeyLinkedMap().setMax(this.MAX_COUNT());
        ThreadScala$.MODULE$.startDaemon("scouter.server.netio.data.MultiPacketProcessor", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    ThreadUtil.sleep(1000L);
                    if (MultiPacketProcessor$.MODULE$.buffer().size() <= 0) continue;
                    try {
                        MultiPacketProcessor$.MODULE$.checkExpired();
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

