/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.req.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import scouter.server.netio.req.net.ReqCommand;
import scouter.server.netio.req.net.ReqCommandFactory;
import scouter.util.DataUtil;

public class TcpAgentReqWorker
extends Thread {
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    public TcpAgentReqWorker(int objHash, Socket socket) {
        this.socket = socket;
        this.setName("SCOUTER-TCP-REQ-" + socket.getRemoteSocketAddress().toString());
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            int cmd;
            ReqCommand command;
            this.socket.setSoTimeout(0);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            while ((command = ReqCommandFactory.makeReqCommand(cmd = DataUtil.readInt(this.in))) != null) {
                command.process(this.in, this.out);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception command) {}
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception command) {}
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception command) {}
            }
        }
    }
}

