/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.util.Set;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.CounterKey;
import scouter.lang.TimeTypeEnum;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.NullValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.server.CounterManager;
import scouter.server.Logger$;
import scouter.server.db.DailyCounterRD$;
import scouter.server.db.ObjectRD$;
import scouter.server.db.RealtimeCounterRD$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.SortUtil;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u001b\tiQ\t\u001f9peR\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\r!\fg\u000e\u001a7f\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011!\u00028fi&|'BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\t1\"A\u0004tG>,H/\u001a:\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012aF3ya>\u0014Ho\u00142kK\u000e$H+[7f\u0007>,h\u000e^3s)\u0011ard\n\u0017\u0011\u0005=i\u0012B\u0001\u0010\u0011\u0005\u0011)f.\u001b;\t\u000b\u0001J\u0002\u0019A\u0011\u0002\u0007\u0011Lg\u000e\u0005\u0002#K5\t1E\u0003\u0002%\u0015\u0005\u0011\u0011n\\\u0005\u0003M\r\u0012!\u0002R1uC&s\u0007/\u001e;Y\u0011\u0015A\u0013\u00041\u0001*\u0003\u0011!w.\u001e;\u0011\u0005\tR\u0013BA\u0016$\u0005-!\u0015\r^1PkR\u0004X\u000f\u001e-\t\u000b5J\u0002\u0019\u0001\u0018\u0002\u000b1|w-\u001b8\u0011\u0005=y\u0013B\u0001\u0019\u0011\u0005\u001d\u0011un\u001c7fC:DC!\u0007\u001a9sA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\nC:|G/\u0019;j_:L!a\u000e\u001b\u0003\u001dM+'O^5dK\"\u000bg\u000e\u001a7fe\u0006)a/\u00197vK\u0006\n!(\u0001\u000eF1B{%\u000bV0P\u0005*+5\tV0U\u00136+ulQ(V\u001dR+%\u000bC\u0003=\u0001\u0011\u0005Q(A\ffqB|'\u000f^(cU\u0016\u001cG\u000fR1uK\u000e{WO\u001c;feR!ADP A\u0011\u0015\u00013\b1\u0001\"\u0011\u0015A3\b1\u0001*\u0011\u0015i3\b1\u0001/Q\u0011Y$\u0007\u000f\"\"\u0003\r\u000bQ$\u0012-Q\u001fJ#vl\u0014\"K\u000b\u000e#vLU#H+2\u000b%kX\"P+:#VI\u0015")
public class ExportService {
    @ServiceHandler(value="EXPORT_OBJECT_TIME_COUNTER")
    public void exportObjectTimeCounter(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        int objHash = param.getInt("objHash");
        String date = param.getText("date");
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        if (stime == 0L) {
            stime = DateUtil.yyyymmdd(date);
            etime = stime + 86400000L;
        }
        ObjectPack objPack = ObjectRD$.MODULE$.getObjectPack(date, objHash);
        Set<String> counterSet = CounterManager.getInstance().getCounterEngine().getCounterSet(objPack.objType);
        String objName = ObjectRD$.MODULE$.getObjName(date, objHash);
        String[] counterArray = SortUtil.sort_string(counterSet.iterator(), counterSet.size());
        MapPack pack = new MapPack();
        ListValue titleLv = pack.newList("values");
        titleLv.add("time");
        Predef$.MODULE$.refArrayOps((Object[])counterArray).foreach((Function1)new Serializable(this, titleLv){
            public static final long serialVersionUID = 0L;
            private final ListValue titleLv$1;

            public final void apply(String key) {
                this.titleLv$1.add(key);
            }
            {
                this.titleLv$1 = titleLv$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(pack);
        Logger$.MODULE$.println(new StringBuilder().append((Object)"EXPORT_OBJECT_TIME_COUNTER ").append((Object)objName).append((Object)"  ").append((Object)date).append((Object)" stime=").append((Object)BoxesRunTime.boxToLong((long)stime)).append((Object)"  etime=").append((Object)BoxesRunTime.boxToLong((long)etime)).toString());
        Serializable handler = new Serializable(this, dout, counterArray){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;
            private final String[] counterArray$1;

            public final boolean apply(long time, MapValue data) {
                MapPack pack1 = new MapPack();
                ListValue valueLv = pack1.newList("values");
                valueLv.add(DateUtil.hhmmss(time));
                Predef$.MODULE$.refArrayOps((Object[])this.counterArray$1).foreach((Function1)new Serializable(this, valueLv, data){
                    public static final long serialVersionUID = 0L;
                    private final ListValue valueLv$1;
                    private final MapValue data$1;

                    public final ListValue apply(String key) {
                        Value v = this.data$1.get(key);
                        return this.valueLv$1.add(v == null ? new TextValue("") : v);
                    }
                    {
                        this.valueLv$1 = valueLv$1;
                        this.data$1 = data$1;
                    }
                });
                this.dout$1.writeByte(3);
                this.dout$1.writePack(pack1);
                return true;
            }
            {
                this.dout$1 = dout$1;
                this.counterArray$1 = counterArray$1;
            }
        };
        RealtimeCounterRD$.MODULE$.read(objName, date, stime, etime, (Function2<Object, MapValue, Object>)handler);
    }

    @ServiceHandler(value="EXPORT_OBJECT_REGULAR_COUNTER")
    public void exportObjectDateCounter(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        int objHash = param.getInt("objHash");
        String date = param.getText("date");
        byte timeType = (byte)param.getInt("timeType");
        ObjectPack objPack = ObjectRD$.MODULE$.getObjectPack(date, objHash);
        Set<String> counterSet = CounterManager.getInstance().getCounterEngine().getCounterSet(objPack.objType);
        Serializable handler = new Serializable(this, objHash, counterSet){
            public static final long serialVersionUID = 0L;
            private final int objHash$1;
            private final Set counterSet$1;

            public final Object apply(byte[] key) {
                CounterKey ck = CounterKey.toCounterKey(key);
                return ck.objHash == this.objHash$1 ? BoxesRunTime.boxToBoolean((boolean)this.counterSet$1.add(ck.counter)) : BoxedUnit.UNIT;
            }
            {
                this.objHash$1 = objHash$1;
                this.counterSet$1 = counterSet$1;
            }
        };
        DailyCounterRD$.MODULE$.readKey(date, (Function1<byte[], Object>)handler);
        String[] counterArray = SortUtil.sort_string(counterSet.iterator(), counterSet.size());
        MapPack pack = new MapPack();
        ListValue titleLv = pack.newList("values");
        titleLv.add("time");
        Predef$.MODULE$.refArrayOps((Object[])counterArray).foreach((Function1)new Serializable(this, titleLv){
            public static final long serialVersionUID = 0L;
            private final ListValue titleLv$2;

            public final void apply(String key) {
                this.titleLv$2.add(key);
            }
            {
                this.titleLv$2 = titleLv$2;
            }
        });
        dout.writeByte(3);
        dout.writePack(pack);
        long stime = DateUtil.yyyymmdd(date);
        long etime = stime + 86400000L;
        int delta = TimeTypeEnum.getTime(timeType);
        for (long time = stime; time < etime; time += (long)delta) {
            String HHmm = DateUtil.hhmm(time);
            int hhmm = CastUtil.cint(HHmm);
            MapPack pack2 = new MapPack();
            ListValue valueLv = pack2.newList("values");
            valueLv.add(new StringBuilder().append((Object)HHmm.substring(0, 2)).append((Object)":").append((Object)HHmm.substring(2, 4)).toString());
            Predef$.MODULE$.refArrayOps((Object[])counterArray).foreach((Function1)new Serializable(this, objHash, date, timeType, hhmm, valueLv){
                public static final long serialVersionUID = 0L;
                private final int objHash$1;
                private final String date$1;
                private final byte timeType$1;
                private final int hhmm$1;
                private final ListValue valueLv$2;

                public final ListValue apply(String key) {
                    CounterKey ck = new CounterKey(this.objHash$1, key, this.timeType$1);
                    Value v = DailyCounterRD$.MODULE$.getValue(this.date$1, ck, this.hhmm$1);
                    return v == null ? this.valueLv$2.add(new NullValue()) : this.valueLv$2.add(v);
                }
                {
                    this.objHash$1 = objHash$1;
                    this.date$1 = date$1;
                    this.timeType$1 = timeType$1;
                    this.hhmm$1 = hhmm$1;
                    this.valueLv$2 = valueLv$2;
                }
            });
            dout.writeByte(3);
            dout.writePack(pack2);
        }
    }
}

