/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.io.File;
import java.util.Properties;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;
import scouter.Version;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.server.Configure;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.util.FileUtil;
import scouter.util.StringUtil;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u001b\tQ1+\u001a:wKJLeNZ8\u000b\u0005\r!\u0011A\u00025b]\u0012dWM\u0003\u0002\u0006\r\u000591/\u001a:wS\u000e,'BA\u0004\t\u0003\u0015qW\r^5p\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u000591oY8vi\u0016\u00148\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003=9W\r^*feZ,'o\u0015;biV\u001cH\u0003\u0002\u000f O1\u0002\"aD\u000f\n\u0005y\u0001\"\u0001B+oSRDQ\u0001I\rA\u0002\u0005\n1\u0001Z5o!\t\u0011S%D\u0001$\u0015\t!#\"\u0001\u0002j_&\u0011ae\t\u0002\u000b\t\u0006$\u0018-\u00138qkRD\u0006\"\u0002\u0015\u001a\u0001\u0004I\u0013\u0001\u00023pkR\u0004\"A\t\u0016\n\u0005-\u001a#a\u0003#bi\u0006|U\u000f\u001e9vibCQ!L\rA\u00029\nQ\u0001\\8hS:\u0004\"aD\u0018\n\u0005A\u0002\"a\u0002\"p_2,\u0017M\u001c\u0015\u00053IB\u0014\b\u0005\u00024m5\tAG\u0003\u00026\t\u0005I\u0011M\\8uCRLwN\\\u0005\u0003oQ\u0012abU3sm&\u001cW\rS1oI2,'/A\u0003wC2,X-I\u0001;\u00035\u0019VI\u0015,F%~\u001bF+\u0011+V'\")A\b\u0001C\u0001{\u0005\u0001r-\u001a;TKJ4XM\u001d,feNLwN\u001c\u000b\u00059yz\u0004\tC\u0003!w\u0001\u0007\u0011\u0005C\u0003)w\u0001\u0007\u0011\u0006C\u0003.w\u0001\u0007a\u0006\u000b\u0003<ea\u0012\u0015%A\"\u0002\u001dM+%KV#S?Z+%kU%P\u001d\")Q\t\u0001C\u0001\r\u0006Yq-\u001a;BO\u0016tG/\u00128w)\u0011ar\tS%\t\u000b\u0001\"\u0005\u0019A\u0011\t\u000b!\"\u0005\u0019A\u0015\t\u000b5\"\u0005\u0019\u0001\u0018)\t\u0011\u0013\u0004hS\u0011\u0002\u0019\u0006Q1+\u0012*W\u000bJ{VI\u0014,\t\u000b9\u0003A\u0011A(\u0002\u001b\u001d,GoU3sm\u0016\u0014H+[7f)\u0011a\u0002+\u0015*\t\u000b\u0001j\u0005\u0019A\u0011\t\u000b!j\u0005\u0019A\u0015\t\u000b5j\u0005\u0019\u0001\u0018)\t5\u0013\u0004\bV\u0011\u0002+\u0006Y1+\u0012*W\u000bJ{F+S'F\u0011\u00159\u0006\u0001\"\u0001Y\u000359W\r^*feZ,'\u000fT8hgR!A$\u0017.\\\u0011\u0015\u0001c\u000b1\u0001\"\u0011\u0015Ac\u000b1\u0001*\u0011\u0015ic\u000b1\u0001/Q\u00111&\u0007O/\"\u0003y\u000bqbU#S-\u0016\u0013v\fT(H?2K5\u000b\u0016\u0005\u0006A\u0002!\t!Y\u0001\u0013O\u0016$8+\u001a:wKJdun\u001a#fi\u0006LG\u000e\u0006\u0003\u001dE\u000e$\u0007\"\u0002\u0011`\u0001\u0004\t\u0003\"\u0002\u0015`\u0001\u0004I\u0003\"B\u0017`\u0001\u0004q\u0003\u0006B03q\u0019\f\u0013aZ\u0001\u0012'\u0016\u0013f+\u0012*`\u0019>;u\fR#U\u0003&c\u0005")
public class ServerInfo {
    @ServiceHandler(value="SERVER_STATUS")
    public void getServerStatus(DataInputX din, DataOutputX dout, boolean login) {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        MapPack serverPack = new MapPack();
        serverPack.put("used", usedMemory);
        serverPack.put("total", totalMemory);
        serverPack.put("time", System.currentTimeMillis());
        dout.writeByte(3);
        dout.writePack(serverPack);
    }

    @ServiceHandler(value="SERVER_VERSION")
    public void getServerVersion(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        MapPack serverPack = new MapPack();
        serverPack.put("version", Version.getServerFullVersion());
        dout.writeByte(3);
        dout.writePack(serverPack);
    }

    @ServiceHandler(value="SERVER_ENV")
    public void getAgentEnv(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = new MapPack();
        Properties p = System.getProperties();
        JavaConversions$.MODULE$.asScalaSet(p.keySet()).foreach((Function1)new Serializable(this, m, p){
            public static final long serialVersionUID = 0L;
            private final MapPack m$1;
            private final Properties p$1;

            public final Value apply(Object key) {
                String value = this.p$1.getProperty(key.toString());
                return this.m$1.put(key.toString(), value);
            }
            {
                this.m$1 = m$1;
                this.p$1 = p$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(m);
    }

    @ServiceHandler(value="SERVER_TIME")
    public void getServerTime(DataInputX din, DataOutputX dout, boolean login) {
        MapPack serverPack = new MapPack();
        serverPack.put("time", System.currentTimeMillis());
        dout.writeByte(3);
        dout.writePack(serverPack);
    }

    @ServiceHandler(value="SERVER_LOG_LIST")
    public void getServerLogs(DataInputX din, DataOutputX dout, boolean login) {
        MapPack out = new MapPack();
        File logDir = new File(Configure.getInstance().log_dir);
        if (!logDir.exists()) {
            return;
        }
        ListValue nameLv = out.newList("name");
        ListValue sizeLv = out.newList("size");
        ListValue lastModifiedLv = out.newList("lastModified");
        Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()).foreach((Function1)new Serializable(this, nameLv, sizeLv, lastModifiedLv){
            public static final long serialVersionUID = 0L;
            private final ListValue nameLv$1;
            private final ListValue sizeLv$1;
            private final ListValue lastModifiedLv$1;

            public final void apply(File f) {
                if (f.isFile() && f.getName().endsWith(".log")) {
                    this.nameLv$1.add(f.getName());
                    this.sizeLv$1.add(f.length());
                    this.lastModifiedLv$1.add(f.lastModified());
                }
            }
            {
                this.nameLv$1 = nameLv$1;
                this.sizeLv$1 = sizeLv$1;
                this.lastModifiedLv$1 = lastModifiedLv$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(out);
    }

    @ServiceHandler(value="SERVER_LOG_DETAIL")
    public void getServerLogDetail(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String name = param.getText("name");
        if (StringUtil.isEmpty(name)) {
            return;
        }
        File logFile = new File(Configure.getInstance().log_dir, name);
        if (!logFile.canRead()) {
            return;
        }
        byte[] content = FileUtil.readAll(logFile);
        if (content == null) {
            return;
        }
        dout.writeByte(3);
        dout.writeValue(new TextValue(new String(content)));
    }
}

