/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.net;

import java.net.Socket;
import java.net.SocketAddress;
import scala.Function3;
import scala.MatchError;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.util.FileUtil;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u0011a\u0002V2q\u0003\u001e,g\u000e^,pe.,'O\u0003\u0002\u0004\t\u0005\u0019a.\u001a;\u000b\u0005\u00151\u0011aB:feZL7-\u001a\u0006\u0003\u000f!\tQA\\3uS>T!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011aB:d_V$XM]\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u000511o\\2lKR\u0004\"aF\u000e\u000e\u0003aQ!aA\r\u000b\u0003i\tAA[1wC&\u0011A\u0004\u0007\u0002\u0007'>\u001c7.\u001a;\t\u0011y\u0001!\u0011!Q\u0001\n}\t!!\u001b8\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tR\u0011AA5p\u0013\t!\u0013E\u0001\u0006ECR\f\u0017J\u001c9vibC\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0004_V$\bC\u0001\u0011)\u0013\tI\u0013EA\u0006ECR\fw*\u001e;qkRD\u0006\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u0011A\u0014x\u000e^8d_2\u0004\"aD\u0017\n\u00059\u0002\"aA%oi\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"RA\r\u001b6m]\u0002\"a\r\u0001\u000e\u0003\tAQ!F\u0018A\u0002YAQAH\u0018A\u0002}AQAJ\u0018A\u0002\u001dBQaK\u0018A\u00021Bq!\u000f\u0001C\u0002\u0013\u0005!(\u0001\u0006sK6|G/Z!eIJ,\u0012a\u000f\t\u0003/qJ!!\u0010\r\u0003\u001bM{7m[3u\u0003\u0012$'/Z:t\u0011\u0019y\u0004\u0001)A\u0005w\u0005Y!/Z7pi\u0016\fE\r\u001a:!\u0011\u001d\t\u0005\u00011A\u0005\u0002\t\u000bQ\u0002\\1ti^\u0013\u0018\u000e^3US6,W#A\"\u0011\u0005=!\u0015BA#\u0011\u0005\u0011auN\\4\t\u000f\u001d\u0003\u0001\u0019!C\u0001\u0011\u0006\tB.Y:u/JLG/\u001a+j[\u0016|F%Z9\u0015\u0005%c\u0005CA\bK\u0013\tY\u0005C\u0001\u0003V]&$\bbB'G\u0003\u0003\u0005\raQ\u0001\u0004q\u0012\n\u0004BB(\u0001A\u0003&1)\u0001\bmCN$xK]5uKRKW.\u001a\u0011\t\u000bE\u0003A\u0011\u0001*\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007%\u001bF\fC\u0003U!\u0002\u0007Q+A\u0002d[\u0012\u0004\"AV-\u000f\u0005=9\u0016B\u0001-\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u0003\u0002\"B/Q\u0001\u0004q\u0016!\u00019\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u00029bG.T!a\u0019\u0006\u0002\t1\fgnZ\u0005\u0003K\u0002\u0014A\u0001U1dW\")q\r\u0001C\u0001Q\u0006A!/Z1e!\u0006\u001c7\u000eF\u0001_\u0011\u0015Q\u0007\u0001\"\u0001l\u0003!\u0011X-\u00193CsR,G#\u00017\u0011\u0005=i\u0017B\u00018\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u000bA\u0004A\u0011A9\u0002\tI,\u0017\r\u001a\u000b\u0003\u0013JDQa]8A\u0002Q\fq\u0001[1oI2,'\u000f\u0005\u0004\u0010k2zr%S\u0005\u0003mB\u0011\u0011BR;oGRLwN\\\u001a\t\u000ba\u0004A\u0011A=\u0002\u0011%\u001c8\t\\8tK\u0012$\u0012A\u001f\t\u0003\u001fmL!\u0001 \t\u0003\u000f\t{w\u000e\\3b]\"9a\u0010\u0001b\u0001\n\u0003y\u0018\u0001B2p]\u001a,\"!!\u0001\u0011\t\u0005\r\u0011QA\u0007\u0002\u0011%\u0019\u0011q\u0001\u0005\u0003\u0013\r{gNZ5hkJ,\u0007\u0002CA\u0006\u0001\u0001\u0006I!!\u0001\u0002\u000b\r|gN\u001a\u0011\t\r\u0005=\u0001\u0001\"\u0001z\u0003%I7/\u0012=qSJ,G\rC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002\u001bM,g\u000eZ&fKB\fE.\u001b<f)\rI\u0015q\u0003\u0005\b\u00033\t\t\u00021\u0001-\u0003!9\u0018-\u001b;US6,\u0007bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\u0006G2|7/\u001a\u000b\u0002\u0013\u0002")
public class TcpAgentWorker {
    private final Socket socket;
    private final DataInputX in;
    private final DataOutputX out;
    private final int protocol;
    private final SocketAddress remoteAddr;
    private long lastWriteTime;
    private final Configure conf;

    public SocketAddress remoteAddr() {
        return this.remoteAddr;
    }

    public long lastWriteTime() {
        return this.lastWriteTime;
    }

    public void lastWriteTime_$eq(long x$1) {
        this.lastWriteTime = x$1;
    }

    public void write(String cmd, Pack p) {
        if (this.socket.isClosed()) {
            return;
        }
        try {
            int n = this.protocol;
            switch (n) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                case -889319422: {
                    byte[] buff = new DataOutputX().writeText(cmd).writePack(p).toByteArray();
                    DataOutputX dataOutputX = this.out.writeIntBytes(buff);
                    break;
                }
                case -889319423: {
                    this.out.writeText(cmd);
                    DataOutputX dataOutputX = this.out.writePack(p);
                }
            }
            this.out.flush();
            this.lastWriteTime_$eq(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            this.close();
        }
    }

    public Pack readPack() {
        try {
            Pack pack;
            if (this.socket.isClosed()) {
                pack = null;
            } else {
                int n = this.protocol;
                switch (n) {
                    default: {
                        throw new RuntimeException("unknown potocol ");
                    }
                    case -889319422: {
                        byte[] buff = this.in.readIntBytes();
                        pack = new DataInputX(buff).readPack();
                        break;
                    }
                    case -889319423: {
                        pack = this.in.readPack();
                    }
                }
            }
            return pack;
        }
        catch (Throwable throwable) {
            this.close();
            return null;
        }
    }

    public byte readByte() {
        try {
            return this.socket.isClosed() ? (byte)0 : this.in.readByte();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close();
            return 0;
        }
    }

    public void read(Function3<Object, DataInputX, DataOutputX, BoxedUnit> handler) {
        try {
            handler.apply((Object)BoxesRunTime.boxToInteger((int)this.protocol), (Object)this.in, (Object)this.out);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close();
        }
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public Configure conf() {
        return this.conf;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.lastWriteTime() >= (long)this.conf().net_tcp_agent_keepalive_interval_ms;
    }

    public void sendKeepAlive(int waitTime) {
        if (this.socket.isClosed()) {
            return;
        }
        int orgSoTime = this.socket.getSoTimeout();
        this.socket.setSoTimeout(waitTime);
        this.write("KEEP_ALIVE", new MapPack());
        try {
            while (3 == this.in.readByte()) {
                int n = this.protocol;
                switch (n) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    case -889319422: {
                        Object object = this.in.readIntBytes();
                        break;
                    }
                    case -889319423: {
                        Object object = this.in.readPack();
                    }
                }
            }
            this.socket.setSoTimeout(orgSoTime);
        }
        catch (Throwable throwable) {
            this.close();
        }
    }

    public void close() {
        FileUtil.close(this.in);
        FileUtil.close(this.out);
        FileUtil.close(this.socket);
        if (this.conf().log_tcp_action_enabled) {
            Logger$.MODULE$.println(new StringBuilder().append((Object)"Agent : ").append((Object)this.remoteAddr()).append((Object)" close").toString());
        }
    }

    public TcpAgentWorker(Socket socket, DataInputX in, DataOutputX out, int protocol) {
        this.socket = socket;
        this.in = in;
        this.out = out;
        this.protocol = protocol;
        this.remoteAddr = socket.getRemoteSocketAddress();
        socket.setSoTimeout(Configure.getInstance().net_tcp_agent_so_timeout_ms);
        this.lastWriteTime = System.currentTimeMillis();
        this.conf = Configure.getInstance();
    }
}

