/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin.alert;

import scouter.lang.CounterKey;
import scouter.lang.value.Value;
import scouter.server.plugin.alert.AlertConf;
import scouter.server.plugin.alert.AlertRule;
import scouter.server.plugin.alert.AlertRuleLoader;
import scouter.server.plugin.alert.RealCounter;
import scouter.util.LinkedMap;

public class AlertEngine {
    static LinkedMap<CounterKey, RealCounter> realTimeMap = new LinkedMap().setMax(3000);

    public static void putRealTime(CounterKey key, Value value) {
        AlertRuleLoader loader = AlertRuleLoader.getInstance();
        AlertRule rule = loader.alertRuleTable.get(key.counter);
        if (rule == null) {
            return;
        }
        RealCounter realCounter = realTimeMap.get(key);
        AlertConf alertConf = loader.alertConfTable.get(key.counter);
        if (alertConf == null) {
            alertConf = new AlertConf();
        }
        if (realCounter == null) {
            realCounter = new RealCounter(key);
            realTimeMap.put(key, realCounter);
            realCounter.historySize(alertConf.history_size);
            realCounter.silentTime(alertConf.silent_time);
            realCounter.checkTerm(alertConf.check_term);
        }
        if (alertConf.lastModified > realCounter.confLastModified) {
            realCounter.confLastModified = alertConf.lastModified;
            realCounter.historySize(alertConf.history_size);
            realCounter.silentTime(alertConf.silent_time);
            realCounter.checkTerm(alertConf.check_term);
        }
        realCounter.setValue(value);
        if (realCounter.checkTerm() > 0) {
            long now = System.currentTimeMillis();
            if (now - (long)(realCounter.checkTerm() * 1000) > realCounter.lastCheckTime) {
                realCounter.lastCheckTime = now;
                rule.process(realCounter);
            }
        } else {
            rule.process(realCounter);
        }
        realCounter.addValueHistory((Number)((Object)value));
    }

    public static void load() {
        AlertRuleLoader.getInstance();
    }
}

