/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin.alert;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.core.cache.AlertScriptLoadMessageCache;
import scouter.server.plugin.alert.AlertConf;
import scouter.server.plugin.alert.AlertRule;
import scouter.server.plugin.alert.RealCounter;
import scouter.util.BitUtil;
import scouter.util.CastUtil;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.LongSet;
import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public class AlertRuleLoader
extends Thread {
    public static final String ALERT_FILE_SUFFIX = ".alert";
    public static final String CONF_FILE_SUFFIX = ".conf";
    private static AlertRuleLoader instance;
    public StringKeyLinkedMap<AlertRule> alertRuleTable = new StringKeyLinkedMap();
    public StringKeyLinkedMap<AlertConf> alertConfTable = new StringKeyLinkedMap();
    private LongSet compileErrorFiles = new LongSet();

    public static synchronized AlertRuleLoader getInstance() {
        if (instance == null) {
            instance = new AlertRuleLoader();
            instance.setDaemon(true);
            instance.setName("AlertRuleLoader");
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            ThreadUtil.sleep(5000L);
            try {
                File root = new File(Configure.getInstance().plugin_dir);
                if (root == null || !root.canRead()) continue;
                this.checkModified(root);
                this.checkNewRule(root);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public String getRuleContents(String counterName) {
        return this.getContentsOfFile(counterName, ALERT_FILE_SUFFIX);
    }

    public String getRuleConfigContents(String counterName) {
        return this.getContentsOfFile(counterName, CONF_FILE_SUFFIX);
    }

    private String getContentsOfFile(String counterName, String fileSuffix) {
        String contents = "";
        try {
            File ruleFile = new File(Configure.getInstance().plugin_dir + "/" + counterName + fileSuffix);
            if (ruleFile.canRead()) {
                contents = new String(FileUtil.readAll(ruleFile));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return contents;
    }

    public boolean saveRuleContents(String counterName, String contents) {
        File ruleFile = new File(Configure.getInstance().plugin_dir + "/" + counterName + ALERT_FILE_SUFFIX);
        return FileUtil.saveText(ruleFile, contents);
    }

    public boolean saveConfigContents(String counterName, String contents) {
        File confFile = new File(Configure.getInstance().plugin_dir + "/" + counterName + CONF_FILE_SUFFIX);
        return FileUtil.saveText(confFile, contents);
    }

    private void checkNewRule(File root) {
        File[] ruleFiles = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(AlertRuleLoader.ALERT_FILE_SUFFIX);
            }
        });
        for (int i = 0; i < ruleFiles.length; ++i) {
            AlertRule rule;
            String name = this.getRuleName(ruleFiles[i].getName());
            if (this.alertRuleTable.containsKey(name) || (rule = this.createRule(name, ruleFiles[i])) == null) continue;
            AlertConf conf = this.createConf(name, this.getConfFile(ruleFiles[i]));
            this.alertRuleTable.put(name, rule);
            this.alertConfTable.put(name, conf);
        }
    }

    private void clear(String name) {
        this.alertRuleTable.remove(name);
        this.alertConfTable.remove(name);
        Logger.println("S217", "Clear alert rule : " + name);
        AlertScriptLoadMessageCache.put("Alert rule cleared : " + name);
    }

    private void checkModified(File root) {
        StringEnumer en = this.alertRuleTable.keys();
        while (en.hasMoreElements()) {
            String name = en.nextString();
            AlertRule rule = this.alertRuleTable.get(name);
            File ruleFile = new File(root, name + ALERT_FILE_SUFFIX);
            if (!ruleFile.canRead() || rule == null) {
                this.clear(name);
                continue;
            }
            if (ruleFile.lastModified() != rule.__lastModified) {
                rule = this.createRule(name, ruleFile);
                this.alertRuleTable.put(name, rule);
            }
            File ruleConf = new File(root, name + CONF_FILE_SUFFIX);
            AlertConf conf = this.alertConfTable.get(name);
            if (conf.lastModified == ruleConf.lastModified()) continue;
            conf = this.createConf(name, ruleConf);
            this.alertConfTable.put(name, conf);
        }
    }

    private String getRuleName(String name) {
        name = name.substring(0, name.lastIndexOf(46));
        return name;
    }

    private File getConfFile(File ruleFile) {
        if (ruleFile == null) {
            return null;
        }
        File conf = new File(ruleFile.getPath().substring(0, ruleFile.getPath().lastIndexOf(46)) + CONF_FILE_SUFFIX);
        if (conf.canRead()) {
            return conf;
        }
        return null;
    }

    private AlertConf createConf(String name, File confFile) {
        AlertConf conf = new AlertConf();
        if (confFile != null && confFile.canRead()) {
            conf.lastModified = confFile.lastModified();
            byte[] body = FileUtil.readAll(confFile);
            if (body != null) {
                Properties p = new Properties();
                try {
                    p.load(new ByteArrayInputStream(body));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                conf.history_size = this.getInt(p, "history_size", 0);
                conf.silent_time = this.getInt(p, "silent_time", 0);
                conf.check_term = this.getInt(p, "check_term", 0);
            }
        }
        return conf;
    }

    private AlertRule createRule(String name, File ruleFile) {
        long fileSignature = this.fileSign(ruleFile);
        if (this.compileErrorFiles.contains(fileSignature)) {
            return null;
        }
        try {
            String body = new String(FileUtil.readAll(ruleFile));
            ClassPool cp = ClassPool.getDefault();
            if (this.getClass().getClassLoader() instanceof URLClassLoader) {
                URLClassLoader u = (URLClassLoader)this.getClass().getClassLoader();
                URL[] urls = u.getURLs();
                for (int i = 0; urls != null && i < urls.length; ++i) {
                    try {
                        cp.appendClassPath(urls[i].getFile());
                        continue;
                    }
                    catch (NotFoundException e) {
                        Logger.println("S219", "[Error]" + e.getMessage());
                    }
                }
            }
            name = "scouter.server.alert.impl." + name;
            Class c = null;
            CtClass cc = cp.get(AlertRule.class.getName());
            CtClass impl = null;
            CtMethod method = null;
            try {
                impl = cp.get(name);
                impl.defrost();
                method = impl.getMethod("process", "(" + this.nativeName(RealCounter.class) + ")V");
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(name, cc);
                method = CtNewMethod.make((String)("public void process(" + RealCounter.class.getName() + " c){}"), (CtClass)impl);
                impl.addMethod(method);
            }
            method.setBody("{" + RealCounter.class.getName() + " $counter=$1;" + body + "\n}");
            c = impl.toClass((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), null);
            AlertRule rule = (AlertRule)c.newInstance();
            rule.__lastModified = ruleFile.lastModified();
            Logger.println("S215", "Alert rule detected : " + ruleFile.getName());
            AlertScriptLoadMessageCache.put("Alert rule detected : " + ruleFile.getName());
            return rule;
        }
        catch (CannotCompileException ee) {
            this.compileErrorFiles.add(fileSignature);
            Logger.println("S212", ee.getMessage());
            AlertScriptLoadMessageCache.put("Alert rule compile error : " + ee.getMessage());
        }
        catch (Exception e) {
            Logger.println("S213", e);
            AlertScriptLoadMessageCache.put("error : " + e.getMessage());
        }
        return null;
    }

    private long fileSign(File f) {
        if (f == null) {
            return 0L;
        }
        String filename = f.getName();
        long filetime = f.lastModified();
        return BitUtil.setHigh(filetime, HashUtil.hash(filename));
    }

    private String nativeName(Class class1) {
        return "L" + class1.getName().replace('.', '/') + ";";
    }

    protected int getInt(Properties p, String key, int defValue) {
        String value = StringUtil.trimEmpty(p.getProperty(key));
        if (value.length() == 0) {
            return defValue;
        }
        return CastUtil.cint(value);
    }
}

