/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin.alert;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import scouter.lang.CounterKey;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.conf.Internal;
import scouter.lang.conf.ParamDesc;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.Value;
import scouter.server.core.AgentManager;
import scouter.server.core.cache.CounterCache;
import scouter.server.plugin.alert.AlertUtil;
import scouter.util.HashUtil;
import scouter.util.IntLongLinkedMap;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;

public class RealCounter {
    private static List<Desc> realCounterDesc;
    public long confLastModified;
    public long lastCheckTime;
    private Value _value;
    private long _time;
    private LongKeyLinkedMap<Number> _history;
    private IntLongLinkedMap _lastAlertTime;
    private String _objType;
    private String _objName;
    private int _silentTime;
    private int _checkTerm;
    private int _objHash;
    private String _counter;
    private byte _timetype;

    public RealCounter(CounterKey key) {
        this._objHash = key.objHash;
        this._counter = key.counter;
        this._timetype = key.timetype;
    }

    @ConfigDesc(value="get current counter name.")
    public String getCounter() {
        return this._counter;
    }

    @Deprecated
    public String counter() {
        return this._counter;
    }

    @ConfigDesc(value="get current object hash value.")
    public int getObjHash() {
        return this._objHash;
    }

    @Deprecated
    public int objHash() {
        return this._objHash;
    }

    @ConfigDesc(value="get current object name.")
    public String getObjName() {
        if (this._objName != null) {
            return this._objName;
        }
        ObjectPack a = AgentManager.getAgent(this._objHash);
        if (a != null && a.objName != null) {
            this._objName = a.objName;
        }
        return this._objName;
    }

    @Deprecated
    public String objName() {
        return this.getObjName();
    }

    @ConfigDesc(value="get current object type name.")
    public String getObjType() {
        ObjectPack a = AgentManager.getAgent(this._objHash);
        if (a == null) {
            return this._objType;
        }
        if (a.objType != null) {
            this._objType = a.objType;
        }
        return this._objType;
    }

    @ConfigDesc(value="get comma separated object hashes string of the given object type.")
    public String getObjHashListString(String objType2) {
        return AgentManager.getObjHashListAsString(objType2);
    }

    @ConfigDesc(value="get comma separated object hashes string of the given object type.")
    public String getObjHashListWithParentsString(String objType2) {
        String[] hashes = this.getObjHashListString(objType2).split(",");
        ArrayList<Integer> hashesWithParents = new ArrayList<Integer>();
        for (String hash : hashes) {
            int objHash = Integer.parseInt(hash);
            hashesWithParents.add(objHash);
            ObjectPack objectPack = AgentManager.getAgent(objHash);
            String objName = objectPack.objName;
            if (objName.lastIndexOf(47) <= 0) continue;
            hashesWithParents.add(HashUtil.hash(objName.substring(0, objName.lastIndexOf(47))));
        }
        return hashesWithParents.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    @Deprecated
    public String objType() {
        return this.getObjType();
    }

    @Internal
    public void setValue(Value v) {
        this._value = v;
        this._time = System.currentTimeMillis();
    }

    @Deprecated
    public void value(Value v) {
        this.setValue(v);
    }

    @ConfigDesc(value="get value of current counter as int.")
    public int getIntValue() {
        if (this._value instanceof Number) {
            return ((Number)((Object)this._value)).intValue();
        }
        return 0;
    }

    @Deprecated
    public int intValue() {
        return this.getIntValue();
    }

    @ConfigDesc(value="get value of current counter as float.")
    public float getFloatValue() {
        if (this._value instanceof Number) {
            return ((Number)((Object)this._value)).floatValue();
        }
        return 0.0f;
    }

    @Deprecated
    public float floatValue() {
        return this.getFloatValue();
    }

    @ConfigDesc(value="get the history size of the counter.")
    public int getHistorySize() {
        return this._history == null ? 0 : this._history.size();
    }

    @Deprecated
    public int historySize() {
        return this.getHistorySize();
    }

    @ConfigDesc(value="get how many times exceed the given value of the counter.")
    @ParamDesc(value="int value, int sec")
    public int getOverCount(int value, int sec) {
        return this.getOverCount((float)value, sec);
    }

    @Deprecated
    public int overCount(int value, int sec) {
        return this.getOverCount(value, sec);
    }

    @ConfigDesc(value="get how many times exceed the given value of the counter.")
    @ParamDesc(value="float value, int sec")
    public int getOverCount(float value, int sec) {
        long tm;
        if (this.getHistorySize() == 0) {
            return 0;
        }
        long from = System.currentTimeMillis() - (long)sec * 1000L;
        int cnt = 0;
        LongEnumer en = this._history.keys();
        while (en.hasMoreElements() && (tm = en.nextLong()) >= from) {
            Number val = this._history.get(tm);
            if (!(val.floatValue() >= value)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Deprecated
    public int overCount(float value, int sec) {
        return this.getOverCount(value, sec);
    }

    @ConfigDesc(value="get average value of the counter in the given duration as int.")
    @ParamDesc(value="int fromAgoSec, int durationSec")
    public int getAvgToInt(int fromAgoSec, int durationSec) {
        return (int)this.getAvg(fromAgoSec, durationSec);
    }

    @Deprecated
    public int getAvgtoInt(int fromAgoSec, int durationSec) {
        return this.getAvgToInt(fromAgoSec, durationSec);
    }

    @ConfigDesc(value="get latest average value of the counter in the given duration.")
    @ParamDesc(value="int durationSec")
    public float getLatestAvg(int durationSec) {
        return this.getAvg(durationSec, durationSec);
    }

    @ConfigDesc(value="get latest average value of the counter in the given duration as int.")
    @ParamDesc(value="int durationSec")
    public int getLatestAvgToInt(int durationSec) {
        return (int)this.getLatestAvg(durationSec);
    }

    @Deprecated
    public int getLatestAvgtoInt(int durationSec) {
        return this.getLatestAvgToInt(durationSec);
    }

    @ConfigDesc(value="get average value of the counter in the given duration.")
    @ParamDesc(value="int fromAgoSec, int durationSec")
    public float getAvg(int fromAgoSec, int durationSec) {
        long tm;
        if (this.getHistorySize() == 0) {
            return 0.0f;
        }
        long from = System.currentTimeMillis() - (long)fromAgoSec * 1000L;
        long to = from + (long)durationSec * 1000L;
        int cnt = 0;
        float sum = 0.0f;
        LongEnumer en = this._history.keys();
        while (en.hasMoreElements() && (tm = en.nextLong()) >= from) {
            if (tm >= to) continue;
            Number val = this._history.get(tm);
            sum += val.floatValue();
            ++cnt;
        }
        if (cnt == 0) {
            return 0.0f;
        }
        return sum / (float)cnt;
    }

    @ConfigDesc(value="get oldest time of the counter's history.")
    public long getHistoryOldestTime() {
        if (this.getHistorySize() == 0) {
            return 0L;
        }
        long tm = this._history.getLastKey();
        long now = System.currentTimeMillis();
        return (now - tm) / 1000L;
    }

    @Deprecated
    public long historyOldestTime() {
        return this.getHistoryOldestTime();
    }

    @ConfigDesc(value="get how many values (of the current counter) exist in the seconds.")
    public int getHistoryCountInSec(int sec) {
        long tm;
        if (this.getHistorySize() == 0) {
            return 0;
        }
        long from = System.currentTimeMillis() - (long)sec * 1000L;
        int cnt = 0;
        LongEnumer en = this._history.keys();
        while (en.hasMoreElements() && (tm = en.nextLong()) >= from) {
            ++cnt;
        }
        return cnt;
    }

    @Deprecated
    public int historyCount(int sec) {
        return this.getHistoryCountInSec(sec);
    }

    @ConfigDesc(value="get the counter's value as float.")
    @ParamDesc(value="String counter")
    public float getFloatValue(String counter) {
        Value v = CounterCache.get(new CounterKey(this._objHash, counter, this._timetype));
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    @ConfigDesc(value="get the another objects counter's value as float.")
    @ParamDesc(value="String objectFullName, String counter")
    public float getFloatValue(String objectFullName, String counter) {
        int anotherObjHash = HashUtil.hash(objectFullName);
        Value v = CounterCache.get(new CounterKey(anotherObjHash, counter, this._timetype));
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    @Deprecated
    public float floatValue(String counter) {
        return this.getFloatValue(counter);
    }

    @ConfigDesc(value="get the counter's value as int.")
    @ParamDesc(value="String counter")
    public int getIntValue(String counter) {
        Value v = CounterCache.get(new CounterKey(this._objHash, counter, this._timetype));
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    @ConfigDesc(value="get the another objects counter's value as int.")
    @ParamDesc(value="String objectFullName, String counter")
    public int getIntValue(String objectFullName, String counter) {
        int anotherObjHash = HashUtil.hash(objectFullName);
        Value v = CounterCache.get(new CounterKey(anotherObjHash, counter, this._timetype));
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    @Deprecated
    public int intValue(String counter) {
        return this.getIntValue(counter);
    }

    @ConfigDesc(value="alert on info level.")
    @ParamDesc(value="String title, String message")
    public void info(String title, String message) {
        AlertUtil.alert((byte)0, this, title, message);
    }

    @Deprecated
    public void warning(String title, String message) {
        AlertUtil.alert((byte)1, this, title, message);
    }

    @ConfigDesc(value="alert on warn level.")
    @ParamDesc(value="String title, String message")
    public void warn(String title, String message) {
        AlertUtil.alert((byte)1, this, title, message);
    }

    @ConfigDesc(value="alert on error level.")
    @ParamDesc(value="String title, String message")
    public void error(String title, String message) {
        AlertUtil.alert((byte)2, this, title, message);
    }

    @ConfigDesc(value="alert on fatal level.")
    @ParamDesc(value="String title, String message")
    public void fatal(String title, String message) {
        AlertUtil.alert((byte)3, this, title, message);
    }

    @Internal
    public void setAlertTime(byte level, long time) {
        if (this._lastAlertTime == null) {
            this._lastAlertTime = new IntLongLinkedMap().setMax(10);
        }
        this._lastAlertTime.put(level, time);
    }

    @Internal
    public void historySize(int size) {
        if (size <= 0) {
            this._history = null;
        } else {
            if (this._history == null) {
                this._history = new LongKeyLinkedMap();
            }
            this._history.setMax(size);
        }
    }

    @Internal
    public void addValueHistory(Number value) {
        if (this._history == null) {
            return;
        }
        long time = System.currentTimeMillis();
        this._history.putFirst(time, value);
    }

    @Internal
    public void silentTime(int sec) {
        this._silentTime = sec;
    }

    @Internal
    public int silentTime() {
        return this._silentTime;
    }

    @Internal
    public void checkTerm(int sec) {
        this._checkTerm = sec;
    }

    @Internal
    public int checkTerm() {
        return this._checkTerm;
    }

    @Internal
    public long lastAlertTime(int level) {
        if (this._lastAlertTime == null) {
            return 0L;
        }
        return this._lastAlertTime.get(level);
    }

    @Internal
    public String counterNames() {
        Map<String, Value> m = CounterCache.getObjectCounters(this._objHash, (byte)1);
        if (m == null) {
            return "[]";
        }
        return m.keySet().toString();
    }

    public static synchronized List<Desc> getRealCounterDescription() {
        Method[] methods;
        if (realCounterDesc != null) {
            return realCounterDesc;
        }
        ArrayList<Desc> descList = new ArrayList<Desc>();
        for (Method method : methods = RealCounter.class.getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            Deprecated deprecated = method.getAnnotation(Deprecated.class);
            Internal internal = method.getAnnotation(Internal.class);
            if (deprecated != null || internal != null) continue;
            ArrayList<String> typeClassNameList = new ArrayList<String>();
            Class<?>[] clazzes = method.getParameterTypes();
            ParamDesc paramDesc = method.getAnnotation(ParamDesc.class);
            if (paramDesc != null) {
                typeClassNameList.add(paramDesc.value());
            } else {
                for (Class<?> clazz : clazzes) {
                    typeClassNameList.add(clazz.getName());
                }
            }
            ConfigDesc configDesc = method.getAnnotation(ConfigDesc.class);
            Desc desc = new Desc();
            desc.methodName = method.getName();
            desc.returnTypeName = method.getReturnType().getName();
            if (configDesc != null) {
                desc.desc = configDesc.value();
            }
            desc.parameterTypeNames = typeClassNameList;
            descList.add(desc);
        }
        realCounterDesc = descList;
        return realCounterDesc;
    }

    public static class Desc {
        public String desc;
        public String methodName;
        public List<String> parameterTypeNames;
        public String returnTypeName;
    }
}

