/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.support.telegraf;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import scouter.server.support.telegraf.TgCounterMapping;

@XmlRootElement(name="measurement")
public class TgmConfig {
    public static final String DEFAULT_OBJ_TYPE_PREPEND_TAG = "scouter_obj_type_prefix";
    public String measurementName;
    public boolean enabled = true;
    public boolean debugEnabled = false;
    public String objFamilyBase = "";
    @XmlElementWrapper
    @XmlElement(name="tag")
    public List<String> objFamilyAppendTags = new ArrayList<String>();
    public String objTypeBase = "";
    @XmlElementWrapper
    @XmlElement(name="tag")
    public List<String> objTypePrependTags = new ArrayList<String>(Arrays.asList("scouter_obj_type_prefix"));
    @XmlElementWrapper
    @XmlElement(name="tag")
    public List<String> objTypeAppendTags = new ArrayList<String>();
    public String objTypeIcon = "";
    public String objNameBase = "";
    @XmlElementWrapper
    @XmlElement(name="tag")
    public List<String> objNameAppendTags = new ArrayList<String>();
    public String hostTag = "host";
    @XmlElementWrapper
    @XmlElement(name="hostMapping")
    public List<HostMapping> hostMappings = new ArrayList<HostMapping>();
    @XmlElementWrapper
    @XmlElement(name="tagFilter")
    public List<TagFilter> tagFilters = new ArrayList<TagFilter>();
    @XmlElementWrapper
    @XmlElement(name="counterMapping")
    public List<TgCounterMapping> counterMappings = new ArrayList<TgCounterMapping>();

    public TgmConfig() {
    }

    public TgmConfig(String measurementName) {
        this.measurementName = measurementName;
    }

    public static void main(String[] args) throws JAXBException {
        TgmConfig tgmConfig = new TgmConfig("M1");
        tgmConfig.objFamilyAppendTags.add("tag1");
        tgmConfig.objFamilyAppendTags.add("tag2");
        tgmConfig.objTypeAppendTags.add("tg1");
        tgmConfig.objTypeAppendTags.add("tg2");
        tgmConfig.hostMappings.add(new HostMapping("host1", "sc-host1"));
        tgmConfig.hostMappings.add(new HostMapping("host2", "sc-host2"));
        tgmConfig.tagFilters.add(new TagFilter("cpu", "cpu0", "cpu1"));
        tgmConfig.tagFilters.add(new TagFilter("mem", "mem0", "mem1"));
        TgCounterMapping tgCounterMapping = new TgCounterMapping("cpu", "cpu", "CPU");
        TgCounterMapping tgCounterMapping2 = new TgCounterMapping("mem", "mem", "MEM");
        tgmConfig.counterMappings.add(tgCounterMapping);
        tgmConfig.counterMappings.add(tgCounterMapping2);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TgmConfig.class});
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)tgmConfig, (OutputStream)System.out);
        m.marshal((Object)tgmConfig, new File("./temp.xml"));
        Unmarshaller um = jc.createUnmarshaller();
        Object o = um.unmarshal(new File("./temp.xml"));
        System.out.println(o);
    }

    public static class TagFilter {
        public String tag;
        public List<String> match;

        public TagFilter() {
        }

        public TagFilter(String tag, String ... matches) {
            this.tag = tag;
            this.match = new ArrayList<String>(Arrays.asList(matches));
        }

        public String getTag() {
            return this.tag;
        }

        public List<String> getMatch() {
            return this.match;
        }
    }

    public static class HostMapping {
        public String telegraf;
        public String scouter;

        public HostMapping() {
        }

        public HostMapping(String telegraf, String scouter) {
            this.telegraf = telegraf;
            this.scouter = scouter;
        }
    }
}

