/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt.core;

import java.util.HashMap;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scouter.lang.value.Value;
import scouter.server.Logger$;
import scouter.server.tagcnt.core.CountEnv$;
import scouter.server.tagcnt.core.MoveToNextCollector;
import scouter.server.tagcnt.core.NextTagCountData;
import scouter.server.tagcnt.next.NextTagCountDB$;
import scouter.server.util.ThreadScala$;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public final class MoveToNextCollector$ {
    public static final MoveToNextCollector$ MODULE$;
    private final int MAX_MASTER;
    private final int MAX_QUE_SIZE;
    private final RequestQueue<MoveToNextCollector.CountItem> scouter$server$tagcnt$core$MoveToNextCollector$$queue;
    private HashMap<NextTagCountData, float[]> countTable;
    private long last_save_time;

    static {
        new MoveToNextCollector$();
    }

    private int MAX_MASTER() {
        return this.MAX_MASTER;
    }

    private int MAX_QUE_SIZE() {
        return this.MAX_QUE_SIZE;
    }

    public RequestQueue<MoveToNextCollector.CountItem> scouter$server$tagcnt$core$MoveToNextCollector$$queue() {
        return this.scouter$server$tagcnt$core$MoveToNextCollector$$queue;
    }

    public boolean isQueueOk() {
        return this.scouter$server$tagcnt$core$MoveToNextCollector$$queue().size() < this.MAX_QUE_SIZE();
    }

    public void add(long time, String objType2, long tagKey, Value tagValue, float count) {
        while (!this.isQueueOk()) {
            ThreadUtil.qWait();
            Logger$.MODULE$.println("S182", 10, "queue is full");
        }
        this.scouter$server$tagcnt$core$MoveToNextCollector$$queue().put(new MoveToNextCollector.CountItem(time, objType2, tagKey, tagValue, count));
    }

    public HashMap<NextTagCountData, float[]> countTable() {
        return this.countTable;
    }

    public void countTable_$eq(HashMap<NextTagCountData, float[]> x$1) {
        this.countTable = x$1;
    }

    private long last_save_time() {
        return this.last_save_time;
    }

    private void last_save_time_$eq(long x$1) {
        this.last_save_time = x$1;
    }

    public void scouter$server$tagcnt$core$MoveToNextCollector$$checkSaveToDb() {
        long now = System.currentTimeMillis();
        if (now > this.last_save_time() + 5000L || this.countTable().size() > this.MAX_MASTER()) {
            this.last_save_time_$eq(System.currentTimeMillis());
            if (this.countTable().size() > 0) {
                NextTagCountDB$.MODULE$.add(this.countTable());
                this.countTable_$eq(new HashMap<NextTagCountData, float[]>());
            }
        }
    }

    private MoveToNextCollector$() {
        MODULE$ = this;
        this.MAX_MASTER = 1000;
        this.MAX_QUE_SIZE = 30000;
        this.scouter$server$tagcnt$core$MoveToNextCollector$$queue = new RequestQueue(this.MAX_QUE_SIZE() + 1);
        this.countTable = new HashMap();
        ThreadScala$.MODULE$.startDaemon("scouter.server.tagcnt.core.MoveToNextCollector", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (CountEnv$.MODULE$.running()) {
                    Object object;
                    MoveToNextCollector$.MODULE$.scouter$server$tagcnt$core$MoveToNextCollector$$checkSaveToDb();
                    MoveToNextCollector.CountItem p = MoveToNextCollector$.MODULE$.scouter$server$tagcnt$core$MoveToNextCollector$$queue().get();
                    NextTagCountData key = new NextTagCountData(p.time(), p.objType(), p.tagKey(), p.tagValue());
                    float[] minCountForHour = MoveToNextCollector$.MODULE$.countTable().get(key);
                    if (minCountForHour == null) {
                        minCountForHour = new float[60];
                        object = MoveToNextCollector$.MODULE$.countTable().put(key, minCountForHour);
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    int min = (int)(p.time() / 60000L % 60L);
                    float[] fArray = minCountForHour;
                    fArray[min] = fArray[min] + p.count();
                }
            }
        });
        this.last_save_time = System.currentTimeMillis();
    }
}

