/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt.core;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.Function6;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scouter.lang.value.Value;
import scouter.server.core.CoreRun$;
import scouter.server.tagcnt.core.CountEnv$;
import scouter.server.tagcnt.core.Key;
import scouter.server.tagcnt.core.TagCountUtil$;
import scouter.server.tagcnt.core.Top100FileCache;
import scouter.server.tagcnt.core.Top100FileCache$;
import scouter.server.tagcnt.core.ValueCount;
import scouter.server.tagcnt.core.ValueCountTotal;
import scouter.server.tagcnt.first.FirstTagCountDB$;
import scouter.server.tagcnt.next.IndexFile;
import scouter.server.tagcnt.next.NextTagCountDB$;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.util.CastUtil;
import scouter.util.FileUtil;
import scouter.util.LongIntMap;
import scouter.util.LongKeyMap;
import scouter.util.LongSet;
import scouter.util.ThreadUtil;

public final class Top100FileCache$ {
    public static final Top100FileCache$ MODULE$;
    private HashSet<Key> scouter$server$tagcnt$core$Top100FileCache$$logSet;

    static {
        new Top100FileCache$();
    }

    public HashSet<Key> scouter$server$tagcnt$core$Top100FileCache$$logSet() {
        return this.scouter$server$tagcnt$core$Top100FileCache$$logSet;
    }

    public void scouter$server$tagcnt$core$Top100FileCache$$logSet_$eq(HashSet<Key> x$1) {
        this.scouter$server$tagcnt$core$Top100FileCache$$logSet = x$1;
    }

    public void add(String logdate, String objType2) {
        this.scouter$server$tagcnt$core$Top100FileCache$$logSet().add(new Key(logdate, objType2));
    }

    public ValueCountTotal readTop100Cache(String logDate, String objType2, long tagName) {
        File file = this.scouter$server$tagcnt$core$Top100FileCache$$getFileName(logDate, objType2, tagName);
        if (!file.exists()) {
            return null;
        }
        byte[] b = FileUtil.readAll(file);
        try {
            return new ValueCountTotal().toObject(b);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public File scouter$server$tagcnt$core$Top100FileCache$$getFileName(String logDate, String objType2, long tagName) {
        File fileRef = new File(CountEnv$.MODULE$.getDBPath(logDate));
        File fileUPFolder = new File(fileRef, objType2);
        Object object = fileUPFolder.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)fileUPFolder.mkdirs());
        return new File(fileUPFolder, new StringBuilder().append((Object)"top100.").append((Object)BoxesRunTime.boxToLong((long)tagName)).append((Object)".dat").toString());
    }

    public LongIntMap getTagNames(String logDate, String objType2) {
        LongKeyMap<Set<Value>> tagmap = FirstTagCountDB$.MODULE$.getTagValues(objType2, logDate);
        LongIntMap tagMap = new LongIntMap();
        EnumerScala$.MODULE$.foreach(tagmap.keys(), (Function1<Object, Object>)new Serializable(tagmap, tagMap){
            public static final long serialVersionUID = 0L;
            private final LongKeyMap tagmap$2;
            private final LongIntMap tagMap$1;

            public final int apply(long tagKey) {
                return this.apply$mcIJ$sp(tagKey);
            }

            public int apply$mcIJ$sp(long tagKey) {
                return this.tagMap$1.put(tagKey, ((Set)this.tagmap$2.get(tagKey)).size());
            }
            {
                this.tagmap$2 = tagmap$2;
                this.tagMap$1 = tagMap$1;
            }
        });
        return tagMap;
    }

    public LongSet getLargeTagSet(String logDate, String objType2) {
        LongKeyMap<Set<Value>> tagmap = FirstTagCountDB$.MODULE$.getTagValues(objType2, logDate);
        LongSet tagMap = new LongSet();
        EnumerScala$.MODULE$.foreach(tagmap.keys(), (Function1<Object, Object>)new Serializable(tagmap, tagMap){
            public static final long serialVersionUID = 0L;
            private final LongKeyMap tagmap$3;
            private final LongSet tagMap$2;

            public final Object apply(long tagKey) {
                Set valueSet = (Set)this.tagmap$3.get(tagKey);
                return valueSet.size() >= 100 ? BoxesRunTime.boxToBoolean((boolean)this.tagMap$2.add(tagKey)) : BoxedUnit.UNIT;
            }
            {
                this.tagmap$3 = tagmap$3;
                this.tagMap$2 = tagMap$2;
            }
        });
        return tagMap;
    }

    public void makeTop100(String date, String objType2, int limit) {
        LongKeyMap map = new LongKeyMap();
        NextTagCountDB$.MODULE$.read(date, objType2, (Function6<Object, Value, Object, long[], IndexFile, Object, Object>)new Serializable(limit, map){
            public static final long serialVersionUID = 0L;
            private final int limit$1;
            private final LongKeyMap map$1;

            public final void apply(long tag, Value value, float tcnt, long[] vpos, IndexFile table, long pos) {
                Object object;
                Top100FileCache.TopItem t = (Top100FileCache.TopItem)this.map$1.get(tag);
                if (t == null) {
                    t = new Top100FileCache.TopItem(tag, this.limit$1);
                    object = this.map$1.put(tag, t);
                } else {
                    object = BoxedUnit.UNIT;
                }
                Top100FileCache.TopItem topItem = t;
                topItem.sumOfValue_$eq(topItem.sumOfValue() + tcnt);
                Top100FileCache.TopItem topItem2 = t;
                topItem2.kindsOfValue_$eq(topItem2.kindsOfValue() + 1);
                t.topN().add(new ValueCount(value, tcnt));
            }
            {
                this.limit$1 = limit$1;
                this.map$1 = map$1;
            }
        });
        LongKeyMap<Set<Value>> tagmap = FirstTagCountDB$.MODULE$.getTagValues(objType2, date);
        LongKeyMap map2 = new LongKeyMap();
        EnumerScala$.MODULE$.foreach(map.keys(), (Function1<Object, Object>)new Serializable(date, objType2, map, tagmap, map2){
            public static final long serialVersionUID = 0L;
            public final String date$1;
            public final String objType$1;
            private final LongKeyMap map$1;
            private final LongKeyMap tagmap$1;
            private final LongKeyMap map2$1;

            public final void apply(long tagName) {
                this.apply$mcVJ$sp(tagName);
            }

            public void apply$mcVJ$sp(long tagName) {
                Top100FileCache.TopItem topItem = (Top100FileCache.TopItem)this.map$1.get(tagName);
                Set out = (Set)this.tagmap$1.get(tagName);
                if (out != null) {
                    EnumerScala$.MODULE$.foreach(out.iterator(), new Serializable(this, topItem, tagName){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.makeTop100.1 $outer;
                        private final Top100FileCache.TopItem topItem$1;
                        private final long tagName$2;

                        public final void apply(Value value) {
                            float[] cnt = FirstTagCountDB$.MODULE$.getTagValueCount(this.$outer.objType$1, this.$outer.date$1, this.tagName$2, value);
                            float countSum = TagCountUtil$.MODULE$.sum(cnt);
                            this.topItem$1.topN().add(new ValueCount(value, countSum));
                            this.topItem$1.kindsOfValue_$eq(this.topItem$1.kindsOfValue() + 1);
                            this.topItem$1.sumOfValue_$eq(this.topItem$1.sumOfValue() + countSum);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.topItem$1 = topItem$1;
                            this.tagName$2 = tagName$2;
                        }
                    });
                }
                ValueCountTotal outMap = new ValueCountTotal();
                this.map2$1.put(tagName, outMap);
                outMap.totalCount_$eq(topItem.sumOfValue());
                outMap.howManyValues_$eq(topItem.kindsOfValue());
                List<ValueCount> sublist = topItem.topN().getList();
                for (int i = 0; i < sublist.size(); ++i) {
                    outMap.values().add(sublist.get(i));
                }
                File file = Top100FileCache$.MODULE$.scouter$server$tagcnt$core$Top100FileCache$$getFileName(this.date$1, this.objType$1, tagName);
                FileUtil.save(file, outMap.toByteArray());
            }
            {
                this.date$1 = date$1;
                this.objType$1 = objType$1;
                this.map$1 = map$1;
                this.tagmap$1 = tagmap$1;
                this.map2$1 = map2$1;
            }
        });
    }

    public LongKeyMap<ValueCountTotal> getEveryTagTop100Value(String date, String objType2, String hhmm, int limit) {
        LongKeyMap map = new LongKeyMap();
        int hm = CastUtil.cint(hhmm);
        int hh = hm / 100;
        int mm = hm % 100;
        NextTagCountDB$.MODULE$.read(date, objType2, (Function6<Object, Value, Object, long[], IndexFile, Object, Object>)new Serializable(limit, map, hh, mm){
            public static final long serialVersionUID = 0L;
            private final int limit$2;
            private final LongKeyMap map$2;
            private final int hh$1;
            private final int mm$1;

            public final Object apply(long tag, Value value, float tcnt, long[] vpos, IndexFile table, long pos) {
                BoxedUnit boxedUnit;
                try {
                    if (vpos[this.hh$1] > 0L) {
                        float[] mcount = table.getValue(vpos[this.hh$1]);
                        if (mcount[this.mm$1] > 0.0f) {
                            Object object;
                            Top100FileCache.TopItem t = (Top100FileCache.TopItem)this.map$2.get(tag);
                            if (t == null) {
                                t = new Top100FileCache.TopItem(tag, this.limit$2);
                                object = this.map$2.put(tag, t);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            Top100FileCache.TopItem topItem = t;
                            topItem.sumOfValue_$eq(topItem.sumOfValue() + mcount[this.mm$1]);
                            Top100FileCache.TopItem topItem2 = t;
                            topItem2.kindsOfValue_$eq(topItem2.kindsOfValue() + 1);
                            t.topN().add(new ValueCount(value, mcount[this.mm$1]));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.limit$2 = limit$2;
                this.map$2 = map$2;
                this.hh$1 = hh$1;
                this.mm$1 = mm$1;
            }
        });
        LongKeyMap<Set<Value>> tagmap = FirstTagCountDB$.MODULE$.getTagValues(objType2, date);
        LongKeyMap<ValueCountTotal> map2 = new LongKeyMap<ValueCountTotal>();
        EnumerScala$.MODULE$.foreach(tagmap.keys(), (Function1<Object, Object>)new Serializable(date, objType2, limit, map, hh, mm, tagmap, map2){
            public static final long serialVersionUID = 0L;
            public final String date$2;
            public final String objType$2;
            private final int limit$2;
            private final LongKeyMap map$2;
            public final int hh$1;
            public final int mm$1;
            private final LongKeyMap tagmap$4;
            private final LongKeyMap map2$2;

            public final ValueCountTotal apply(long tagName) {
                Set out;
                ObjectRef topItem = ObjectRef.create((Object)((Top100FileCache.TopItem)this.map$2.get(tagName)));
                if ((Top100FileCache.TopItem)topItem.elem == null) {
                    topItem.elem = new Top100FileCache.TopItem(tagName, this.limit$2);
                }
                if ((out = (Set)this.tagmap$4.get(tagName)) != null) {
                    EnumerScala$.MODULE$.foreach(out.iterator(), new Serializable(this, topItem, tagName){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getEveryTagTop100Value.2 $outer;
                        private final ObjectRef topItem$2;
                        private final long tagName$1;

                        public final void apply(Value value) {
                            float[] cnt = FirstTagCountDB$.MODULE$.getTagValueCount(this.$outer.objType$2, this.$outer.date$2, this.tagName$1, value);
                            float countForValue = cnt[TagCountUtil$.MODULE$.getBucketPos(this.$outer.hh$1, this.$outer.mm$1)];
                            if (countForValue > 0.0f) {
                                ((Top100FileCache.TopItem)this.topItem$2.elem).topN().add(new ValueCount(value, countForValue));
                                Top100FileCache.TopItem topItem = (Top100FileCache.TopItem)this.topItem$2.elem;
                                topItem.kindsOfValue_$eq(topItem.kindsOfValue() + 1);
                                Top100FileCache.TopItem topItem2 = (Top100FileCache.TopItem)this.topItem$2.elem;
                                topItem2.sumOfValue_$eq(topItem2.sumOfValue() + countForValue);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.topItem$2 = topItem$2;
                            this.tagName$1 = tagName$1;
                        }
                    });
                }
                List<ValueCount> sublist = ((Top100FileCache.TopItem)topItem.elem).topN().getList();
                Collections.sort(sublist, new Comparator<ValueCount>(this){

                    public int compare(ValueCount o1, ValueCount o2) {
                        return (int)(o2.valueCount - o1.valueCount);
                    }
                });
                ValueCountTotal wr = new ValueCountTotal();
                wr.howManyValues_$eq(((Top100FileCache.TopItem)topItem.elem).kindsOfValue());
                wr.totalCount_$eq(((Top100FileCache.TopItem)topItem.elem).sumOfValue());
                wr.values_$eq(sublist);
                return this.map2$2.put(tagName, wr);
            }
            {
                this.date$2 = date$2;
                this.objType$2 = objType$2;
                this.limit$2 = limit$2;
                this.map$2 = map$2;
                this.hh$1 = hh$1;
                this.mm$1 = mm$1;
                this.tagmap$4 = tagmap$4;
                this.map2$2 = map2$2;
            }
        });
        return map2;
    }

    private Top100FileCache$() {
        MODULE$ = this;
        this.scouter$server$tagcnt$core$Top100FileCache$$logSet = new HashSet();
        ThreadScala$.MODULE$.startDaemon("scouter.server.tagcnt.core.Top100FileCache", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (CoreRun$.MODULE$.running()) {
                    ThreadUtil.sleep(300000L);
                    try {
                        HashSet<Key> workSet = Top100FileCache$.MODULE$.scouter$server$tagcnt$core$Top100FileCache$$logSet();
                        Top100FileCache$.MODULE$.scouter$server$tagcnt$core$Top100FileCache$$logSet_$eq(new HashSet<Key>());
                        EnumerScala$.MODULE$.foreach(workSet.iterator(), new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Key key) {
                                Top100FileCache$ top100FileCache$ = Top100FileCache$.MODULE$;
                                synchronized (top100FileCache$) {
                                    Top100FileCache$.MODULE$.makeTop100(key.logDate(), key.objType(), 100);
                                    return;
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
                return;
            }
        });
    }
}

