/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt.next;

import java.io.IOException;
import java.util.Hashtable;
import scala.Function1;
import scala.Function6;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.value.Value;
import scouter.server.Logger$;
import scouter.server.db.io.MemHashBlock;
import scouter.server.tagcnt.core.TagCountUtil$;
import scouter.server.tagcnt.next.DataFile;
import scouter.server.tagcnt.next.ITEM;
import scouter.server.tagcnt.next.IndexFile$;
import scouter.server.tagcnt.next.KeyFile;
import scouter.util.CompareUtil;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005-w!B\u0001\u0003\u0011\u0003Y\u0011!C%oI\u0016Dh)\u001b7f\u0015\t\u0019A!\u0001\u0003oKb$(BA\u0003\u0007\u0003\u0019!\u0018mZ2oi*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003%\tqa]2pkR,'o\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u0013%sG-\u001a=GS2,7CA\u0007\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q#\u0004C\u00011\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\b55\u0011\r\u0011\"\u0001\u001c\u0003\u0015!\u0018M\u00197f+\u0005a\u0002\u0003B\u000f#I-j\u0011A\b\u0006\u0003?\u0001\nA!\u001e;jY*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005%A\u0015m\u001d5uC\ndW\r\u0005\u0002&Q9\u0011\u0011CJ\u0005\u0003OI\ta\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011qE\u0005\t\u0003\u001912AA\u0004\u0002\u0001[M\u0019AF\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u0002\u0013\u0001\u00027b]\u001eL!a\r\u0019\u0003\r=\u0013'.Z2u!\t)t'D\u00017\u0015\ty\u0002\"\u0003\u00029m\t1\u0011j\u00117pg\u0016D\u0001B\u000f\u0017\u0003\u0002\u0003\u0006I\u0001J\u0001\u0005a\u0006$\b\u000e\u0003\u0005=Y\t\u0005\t\u0015!\u0003>\u0003!A\u0017m\u001d5TSj,\u0007CA\t?\u0013\ty$CA\u0002J]RDQa\u0006\u0017\u0005\u0002\u0005#2a\u000b\"D\u0011\u0015Q\u0004\t1\u0001%\u0011\u001da\u0004\t%AA\u0002uBq!\u0012\u0017A\u0002\u0013\u0005a)\u0001\u0005sK\u001a\u0014XM\\2f+\u0005i\u0004b\u0002%-\u0001\u0004%\t!S\u0001\re\u00164'/\u001a8dK~#S-\u001d\u000b\u0003\u00156\u0003\"!E&\n\u00051\u0013\"\u0001B+oSRDqAT$\u0002\u0002\u0003\u0007Q(A\u0002yIEBa\u0001\u0015\u0017!B\u0013i\u0014!\u0003:fMJ,gnY3!\u0011\u001d\u0011FF1A\u0005\u0002\u0019\u000b!!\u0014\"\t\rQc\u0003\u0015!\u0003>\u0003\ri%\t\t\u0005\b-2\u0012\r\u0011\"\u0001X\u0003!A\u0017m\u001d5GS2,W#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016AA5p\u0015\tif!\u0001\u0002eE&\u0011qL\u0017\u0002\r\u001b\u0016l\u0007*Y:i\u00052|7m\u001b\u0005\u0007C2\u0002\u000b\u0011\u0002-\u0002\u0013!\f7\u000f\u001b$jY\u0016\u0004\u0003bB2-\u0005\u0004%\t\u0001Z\u0001\bW\u0016Lh)\u001b7f+\u0005)\u0007C\u0001\u0007g\u0013\t9'AA\u0004LKf4\u0015\u000e\\3\t\r%d\u0003\u0015!\u0003f\u0003!YW-\u001f$jY\u0016\u0004\u0003bB6-\u0005\u0004%\t\u0001\\\u0001\tI\u0006$\u0018MR5mKV\tQ\u000e\u0005\u0002\r]&\u0011qN\u0001\u0002\t\t\u0006$\u0018MR5mK\"1\u0011\u000f\fQ\u0001\n5\f\u0011\u0002Z1uC\u001aKG.\u001a\u0011\t\u000bMdC\u0011\u0001;\u0002\u0015\u001d,GoS3z\r&dW\rF\u0001f\u0011\u00151H\u0006\"\u0001x\u0003=9W\r\u001e#bi\u0006\u0004vn]5uS>tGC\u0001=\u007f!\r\t\u0012p_\u0005\u0003uJ\u0011Q!\u0011:sCf\u0004\"!\u0005?\n\u0005u\u0014\"\u0001\u0002'p]\u001eDaa`;A\u0002\u0005\u0005\u0011aA6fsB!\u0011#_A\u0002!\r\t\u0012QA\u0005\u0004\u0003\u000f\u0011\"\u0001\u0002\"zi\u0016Dq!a\u0003-\t\u0003\ti!A\u0005va\u0012\fG/Z!eIR9Q(a\u0004\u0002\u0012\u0005U\u0001bB@\u0002\n\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003'\tI\u00011\u0001>\u0003\u0011Aw.\u001e:\t\u0011\u0005]\u0011\u0011\u0002a\u0001\u00033\tQA^1mk\u0016\u0004B!E=\u0002\u001cA\u0019\u0011#!\b\n\u0007\u0005}!CA\u0003GY>\fG\u000fC\u0004\u0002$1\"\t!!\n\u0002\r!\f7oS3z)\u0011\t9#!\f\u0011\u0007E\tI#C\u0002\u0002,I\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0000\u0003C\u0001\r!!\u0001\t\u000f\u0005EB\u0006\"\u0001\u00024\u0005iq-\u001a;U_R\fGnQ8v]R$B!a\u0007\u00026!9q0a\fA\u0002\u0005\u0005\u0001bBA\u001dY\u0011\u0005\u00111H\u0001\u0005e\u0016\fG\r\u0006\u0003\u0002(\u0005u\u0002\u0002CA \u0003o\u0001\r!!\u0011\u0002\u000f!\fg\u000e\u001a7feBi\u0011#a\u0011|\u0003\u000f\nY\u0002_\u0016|\u0003'J1!!\u0012\u0013\u0005%1UO\\2uS>tg\u0007\u0005\u0003\u0002J\u0005=SBAA&\u0015\u0011\t9\"!\u0014\u000b\u0005EB\u0011\u0002BA)\u0003\u0017\u0012QAV1mk\u0016\u00042!EA+\u0013\r\t9F\u0005\u0002\u0004\u0003:L\bbBA.Y\u0011\u0005\u0011QL\u0001\tO\u0016$h+\u00197vKR!\u0011\u0011DA0\u0011\u001d\t\t'!\u0017A\u0002m\fAA\u001e9pg\"9\u0011Q\r\u0017\u0005\n\u0005\u001d\u0014AB0dY>\u001cX\rF\u0001K\u0011\u001d\tY\u0007\fC!\u0003O\nQa\u00197pg\u0016Dq!a\u001c-\t\u0003\t\t(A\u0006hKR4\u0016\r\\;f\u00032dG\u0003BA\r\u0003gBq!!\u0019\u0002n\u0001\u0007\u0001\u0010C\u0004\u0002x1\"\t!!\u001f\u0002\u0015\rdW-\u00198WC2,X\rF\u0002K\u0003wBq!! \u0002v\u0001\u000710A\u0002q_NDq!!!-\t\u0003\t\u0019)A\u0002bI\u0012$\u0012BSAC\u0003\u0013\u000bi)!%\t\u000f\u0005\u001d\u0015q\u0010a\u0001w\u00061A/Y4LKfD\u0001\"a#\u0002\u0000\u0001\u0007\u0011qI\u0001\ti\u0006<g/\u00197vK\"9\u0011qRA@\u0001\u0004i\u0014A\u00015i\u0011!\t9\"a A\u0002\u0005e\u0001bBAKY\u0011\u0005\u0011qS\u0001\u0004O\u0016$HCBA\r\u00033\u000bY\nC\u0004\u0002\b\u0006M\u0005\u0019A>\t\u0011\u0005-\u00151\u0013a\u0001\u0003\u000fBq!a\t-\t\u0003\ty\n\u0006\u0004\u0002(\u0005\u0005\u00161\u0015\u0005\b\u0003\u000f\u000bi\n1\u0001|\u0011!\tY)!(A\u0002\u0005\u001d\u0003bBAT\u001b\u0001\u0006I\u0001H\u0001\u0007i\u0006\u0014G.\u001a\u0011\t\u000f\u0005-V\u0002\"\u0001\u0002.\u0006!q\u000e]3o)\rY\u0013q\u0016\u0005\u0007u\u0005%\u0006\u0019\u0001\u0013\t\u0013\u0005MV\"%A\u0005\u0002\u0005U\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u00028*\u001aQ(!/,\u0005\u0005m\u0006\u0003BA_\u0003\u000fl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!2\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\fyLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class IndexFile
implements IClose {
    private final String path;
    private int refrence;
    private final int MB;
    private final MemHashBlock hashFile;
    private final KeyFile keyFile;
    private final DataFile dataFile;

    public static int $lessinit$greater$default$2() {
        return IndexFile$.MODULE$.$lessinit$greater$default$2();
    }

    public static IndexFile open(String string) {
        return IndexFile$.MODULE$.open(string);
    }

    public static Hashtable<String, IndexFile> table() {
        return IndexFile$.MODULE$.table();
    }

    public int refrence() {
        return this.refrence;
    }

    public void refrence_$eq(int x$1) {
        this.refrence = x$1;
    }

    public int MB() {
        return this.MB;
    }

    public MemHashBlock hashFile() {
        return this.hashFile;
    }

    public KeyFile keyFile() {
        return this.keyFile;
    }

    public DataFile dataFile() {
        return this.dataFile;
    }

    public KeyFile getKeyFile() {
        return this.keyFile();
    }

    public long[] getDataPosition(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey = this.keyFile().getKey(pos);
            if (CompareUtil.equals(okey, key)) {
                ITEM r = this.keyFile().getRecord(pos);
                return r.pos24h();
            }
            pos = this.keyFile().getHashLink(pos);
        }
        return null;
    }

    public int updateAdd(byte[] key, int hour, float[] value) {
        long pos;
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long firstPos = pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey = this.keyFile().getKey(pos);
            if (CompareUtil.equals(okey, key)) {
                Integer n;
                ITEM r = this.keyFile().getRecord(pos);
                if (r.pos24h()[hour] <= 0L) {
                    long vpos = this.dataFile().append(value);
                    this.keyFile().update(pos, hour, vpos);
                    n = BoxedUnit.UNIT;
                } else {
                    n = BoxesRunTime.boxToInteger((int)this.dataFile().updateAdd(r.pos24h()[hour], value));
                }
                this.keyFile().addTotalCount(pos, TagCountUtil$.MODULE$.sum(value));
                return 1;
            }
            pos = this.keyFile().getHashLink(pos);
        }
        long vpos = this.dataFile().append(value);
        long[] vposArr = new long[24];
        vposArr[hour] = vpos;
        pos = this.keyFile().append(firstPos, key, TagCountUtil$.MODULE$.sum(value), vposArr);
        this.hashFile().put(keyHash, pos);
        return 0;
    }

    public boolean hasKey(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey = this.keyFile().getKey(pos);
            if (CompareUtil.equals(okey, key)) {
                return true;
            }
            pos = this.keyFile().getHashLink(pos);
        }
        return false;
    }

    public float getTotalCount(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey = this.keyFile().getKey(pos);
            if (CompareUtil.equals(okey, key)) {
                return this.keyFile().getTotalCount(pos);
            }
            pos = this.keyFile().getHashLink(pos);
        }
        return 0.0f;
    }

    public boolean read(Function6<Object, Value, Object, long[], IndexFile, Object, Object> handler) {
        if (this.keyFile() == null) {
            return false;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        while (pos < length && pos > 0L) {
            Object object;
            ITEM r = this.keyFile().getRecord(pos);
            if (r.key().length > 0) {
                DataInputX in = new DataInputX(r.key());
                long tag = in.readLong();
                Value value = in.readValue();
                object = handler.apply((Object)BoxesRunTime.boxToLong((long)tag), (Object)value, (Object)BoxesRunTime.boxToFloat((float)r.count()), (Object)r.pos24h(), (Object)this, (Object)BoxesRunTime.boxToLong((long)pos));
            } else {
                object = BoxedUnit.UNIT;
            }
            pos = r.next();
            ++done;
        }
        return true;
    }

    public float[] getValue(long vpos) {
        if (vpos <= 0L) {
            return null;
        }
        return this.dataFile().getValue(vpos);
    }

    private void _close() {
        this.hashFile().close();
        FileUtil.close(this.keyFile());
        FileUtil.close(this.dataFile());
    }

    @Override
    public void close() {
        Hashtable<String, IndexFile> hashtable = IndexFile$.MODULE$.table();
        synchronized (hashtable) {
            IndexFile indexFile;
            if (this.refrence() == 0) {
                this._close();
                indexFile = IndexFile$.MODULE$.table().remove(this.path);
            } else {
                this.refrence_$eq(this.refrence() - 1);
                indexFile = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public float[] getValueAll(long[] vpos) {
        float[] out = new float[1440];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23).foreach$mVc$sp((Function1)new Serializable(this, vpos, out){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexFile $outer;
            private final long[] vpos$1;
            private final float[] out$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                float[] value = this.$outer.getValue(this.vpos$1[i]);
                if (value != null) {
                    System.arraycopy(value, 0, this.out$1, i * 60, 60);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.vpos$1 = vpos$1;
                this.out$1 = out$1;
            }
        });
        return out;
    }

    public void cleanValue(long pos) {
        this.dataFile().write(pos, new float[60]);
    }

    public void add(long tagKey, Value tagvalue, int hh, float[] value) {
        try {
            DataOutputX out = new DataOutputX();
            out.writeLong(tagKey);
            out.writeValue(tagvalue);
            byte[] key = out.toByteArray();
            this.updateAdd(key, hh, value);
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S204", 10, throwable.toString());
        }
    }

    public float[] get(long tagKey, Value tagvalue) {
        DataOutputX key = new DataOutputX();
        key.writeLong(tagKey);
        key.writeValue(tagvalue);
        long[] vpos = this.getDataPosition(key.toByteArray());
        if (vpos == null) {
            return null;
        }
        return this.getValueAll(vpos);
    }

    public boolean hasKey(long tagKey, Value tagvalue) {
        DataOutputX key = new DataOutputX();
        key.writeLong(tagKey);
        key.writeValue(tagvalue);
        return this.hasKey(key.toByteArray());
    }

    public IndexFile(String path, int hashSize) {
        this.path = path;
        this.refrence = 0;
        this.MB = 0x100000;
        this.hashFile = new MemHashBlock(path, hashSize * this.MB());
        this.keyFile = new KeyFile(path);
        this.dataFile = new DataFile(path);
    }
}

