/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.term;

import java.io.IOException;
import scala.tools.jline.TerminalFactory;
import scala.tools.jline.console.ConsoleReader;
import scala.tools.jline.console.completer.Completer;
import scala.tools.jline.console.completer.StringsCompleter;
import scouter.server.ShutdownManager;
import scouter.server.term.AnsiPrint;
import scouter.server.term.handler.Help;
import scouter.server.term.handler.ProcessMain;
import scouter.util.IShutdown;
import scouter.util.ShellArg;
import scouter.util.SystemUtil;

public class TermMain {
    public static void process(ShellArg ar) throws IOException, Exception {
        boolean bl = AnsiPrint.enable = !SystemUtil.IS_WINDOWS;
        if (ar.hasKey("-ansi")) {
            AnsiPrint.enable = true;
        } else if (ar.hasKey("-noansi")) {
            AnsiPrint.enable = false;
        }
        ShutdownManager.add(new IShutdown(){

            @Override
            public void shutdown() {
                try {
                    TerminalFactory.get().restore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ConsoleReader console = new ConsoleReader();
        console.setHistoryEnabled(true);
        console.addCompleter((Completer)new StringsCompleter(Help.words()));
        console.setPrompt(AnsiPrint.green("scouter> "));
        while (true) {
            try {
                while (true) {
                    String cmd = console.readLine();
                    ProcessMain.process(cmd.trim());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void exit() {
        System.exit(0);
    }
}

