/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import scouter.server.Logger;
import scouter.server.db.XLogWR;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.SystemUtil;

public class AutoDeleteTest {
    File dbDir = new File("/Users/gunlee/Documents/workspace/scouter/run-dir/scouter-server/database");
    Set<String> deletedProfileDays = new HashSet<String>();
    Set<String> deletedXLogDays = new HashSet<String>();
    Set<String> deletedDays = new HashSet<String>();
    int maxPercent;
    int retainDays;
    int retainXlogDays;
    int retainCounterDays;
    boolean delOnlyXLog;
    String lastCheckDate;

    private void deleteData(String yyyymmdd, Mode mode) {
        try {
            File f = null;
            if (mode == Mode.ALL) {
                f = new File(this.dbDir, yyyymmdd);
                this.deleteFiles(f);
            } else if (mode == Mode.XLOG) {
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir());
                this.deleteFiles(f);
            } else if (mode == Mode.PROFILE) {
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog.profile");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog_profile.hfile");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog_profile.kfile");
                this.deleteFiles(f);
            } else {
                throw new IllegalArgumentException("Not expected Mode : " + (Object)((Object)mode));
            }
            Logger.println("S206", "Auto deletion... " + yyyymmdd);
        }
        catch (Throwable th) {
            Logger.println("S207", "Failed auto deletion... " + yyyymmdd + "  " + th.toString());
        }
    }

    void deleteFiles(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                this.deleteFiles(c);
            }
        }
        file.delete();
    }

    private String getLongAgoDate(Set<String> exceptDays) {
        File[] dirs = this.dbDir.listFiles();
        if (dirs == null || dirs.length < 1) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < dirs.length; ++i) {
            File f = dirs[i];
            String name = f.getName();
            if (!f.isDirectory() || name.indexOf("0000") != -1 || exceptDays.contains(name)) continue;
            try {
                list.add(Integer.valueOf(f.getName()));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list);
        return String.valueOf(list.get(0));
    }

    public static void main(String[] args) {
        AutoDeleteTest test = new AutoDeleteTest();
        HashSet<String> except = new HashSet<String>();
        except.add("20161119");
        except.add("20170501");
        String longAgo = test.getLongAgoDate(except);
        System.out.println(longAgo);
    }

    public void purge() {
        int retainCounterDays;
        int retainXLogDays;
        int retainProfileDays;
        int maxPercent;
        String today = DateUtil.yyyymmdd();
        if (!SystemUtil.IS_JAVA_1_5 && (maxPercent = 85) > 0) {
            String yyyymmdd;
            long totalSpace = this.dbDir.getTotalSpace();
            long usuableSpace = this.dbDir.getUsableSpace();
            double freePercent = (double)usuableSpace * 100.0 / (double)totalSpace;
            while (100.0 - freePercent > (double)maxPercent && (yyyymmdd = this.getLongAgoDate(this.deletedProfileDays)) != null && !today.equals(yyyymmdd)) {
                this.deleteData(yyyymmdd, Mode.PROFILE);
                usuableSpace = this.dbDir.getUsableSpace();
                freePercent = (double)usuableSpace * 100.0 / (double)totalSpace;
                this.deletedProfileDays.add(yyyymmdd);
            }
            while (100.0 - freePercent > (double)maxPercent && (yyyymmdd = this.getLongAgoDate(this.deletedXLogDays)) != null && !today.equals(yyyymmdd)) {
                this.deleteData(yyyymmdd, Mode.XLOG);
                usuableSpace = this.dbDir.getUsableSpace();
                freePercent = (double)usuableSpace * 100.0 / (double)totalSpace;
                this.deletedXLogDays.add(yyyymmdd);
            }
            while (100.0 - freePercent > (double)maxPercent && (yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && !today.equals(yyyymmdd)) {
                this.deleteData(yyyymmdd, Mode.ALL);
                usuableSpace = this.dbDir.getUsableSpace();
                freePercent = (double)usuableSpace * 100.0 / (double)totalSpace;
                this.deletedDays.add(yyyymmdd);
            }
        }
        if ((retainProfileDays = 10) > 0 && !today.equals(this.lastCheckDate)) {
            String yyyymmdd;
            this.lastCheckDate = today;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainProfileDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedProfileDays)) != null && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.PROFILE);
                this.deletedProfileDays.add(yyyymmdd);
            }
        }
        if ((retainXLogDays = 20) > 0 && !today.equals(this.lastCheckDate)) {
            String yyyymmdd;
            this.lastCheckDate = today;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainXLogDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedXLogDays)) != null && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.XLOG);
                this.deletedXLogDays.add(yyyymmdd);
            }
        }
        if ((retainCounterDays = 30) > 0 && !today.equals(this.lastCheckDate)) {
            String yyyymmdd;
            this.lastCheckDate = today;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainCounterDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.ALL);
                this.deletedDays.add(yyyymmdd);
            }
        }
    }

    static enum Mode {
        PROFILE,
        XLOG,
        ALL;

    }
}

