/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.util.Base64;

public class CipherUtil {
    public static String md5(String plainText) {
        String md5Text = null;
        if (plainText != null) {
            try {
                byte[] byteArray = plainText.getBytes();
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(byteArray);
                byte[] md5Bytes = md5.digest();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < md5Bytes.length; ++i) {
                    if ((md5Bytes[i] & 0xFF) < 16) {
                        buf.append("0");
                    }
                    buf.append(Long.toString(md5Bytes[i] & 0xFF, 16));
                }
                md5Text = buf.toString();
            }
            catch (Throwable t) {
                return plainText;
            }
        }
        return md5Text;
    }

    public static String sha256(String plainText) {
        String salt = "qwertyuiop!@#$%^&*()zxcvbnm,.";
        String sha256Text = null;
        if (plainText != null) {
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                sha256.update(salt.getBytes());
                byte[] byteArray = plainText.getBytes();
                byte[] sha256Bytes = sha256.digest(byteArray);
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < sha256Bytes.length; ++i) {
                    if ((sha256Bytes[i] & 0xFF) < 16) {
                        buf.append("0");
                    }
                    buf.append(Long.toString(sha256Bytes[i] & 0xFF, 16));
                }
                sha256Text = buf.toString();
            }
            catch (Throwable t) {
                return plainText;
            }
        }
        return sha256Text;
    }

    private static Key genKey() throws GeneralSecurityException {
        String nm = CipherUtil.class.getSimpleName();
        byte[] host2 = (nm + "012345678").getBytes();
        byte[] key = new byte[8];
        System.arraycopy(host2, 0, key, 0, 8);
        return SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(key));
    }

    public static String decode(String encoded) {
        try {
            Key key = CipherUtil.genKey();
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(2, key);
            byte[] cyper = Base64.decode(encoded);
            byte[] decoded = cipher.doFinal(cyper);
            return new DataInputX(decoded).readText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encode(String plain) {
        try {
            Key key = CipherUtil.genKey();
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] plainBytes = CipherUtil.padding(new DataOutputX().writeText(plain).toByteArray());
            byte[] encoded = cipher.doFinal(plainBytes);
            return Base64.encode(encoded);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] padding(byte[] src) {
        int destlen = (src.length / 8 + 1) * 8;
        byte[] dest = new byte[destlen];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static String sha2562(String plainText) {
        String salt = "qwertyuiop!@#$%^&*()zxcvbnm,.";
        String sha256Text = null;
        if (plainText != null) {
            try {
                String saltText = salt != null && !"".equals(salt) ? plainText + "{" + salt.toString() + "}" : plainText;
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                byte[] byteArray = saltText.getBytes();
                byte[] sha256Bytes = sha256.digest(byteArray);
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < sha256Bytes.length; ++i) {
                    if ((sha256Bytes[i] & 0xFF) < 16) {
                        buf.append("0");
                    }
                    buf.append(Long.toString(sha256Bytes[i] & 0xFF, 16));
                }
                sha256Text = buf.toString();
            }
            catch (Throwable t) {
                return plainText;
            }
        }
        return sha256Text;
    }

    public static void main(String[] args) {
        String pwd = "admin";
        String md5 = CipherUtil.md5(pwd);
        String cnd = CipherUtil.encode(pwd);
        String rtn = CipherUtil.decode(cnd);
        String sha256 = CipherUtil.sha256(pwd);
        String sha2562 = CipherUtil.sha2562(pwd);
        System.out.println("'" + pwd + "'");
        System.out.println("'" + md5 + "'");
        System.out.println("'" + cnd + "'");
        System.out.println("'" + rtn + "'");
        System.out.println("'" + sha256 + "'");
        System.out.println("'" + sha2562 + "'");
    }
}

