/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.HashSet;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.StringEnumer;

public class StringSet {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient StringSetry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    public static StringEnumer emptyEnumer = new StringEnumer(){

        @Override
        public String nextString() {
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }
    };

    public StringSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringSetry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringSet() {
        this(101, 0.75f);
    }

    public StringSet(String[] arr) {
        this(101, 0.75f);
        if (arr == null) {
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            this.put(arr[i]);
        }
    }

    public int size() {
        return this.count;
    }

    public synchronized StringEnumer keys() {
        return new Enumer();
    }

    public synchronized boolean hasKey(String key) {
        if (key == null) {
            return false;
        }
        StringSetry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        StringSetry e = tab[index];
        while (e != null) {
            if (e.hash == hash && CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringSetry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringSetry[] newMap = new StringSetry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringSetry old = oldMap[i];
            while (old != null) {
                StringSetry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public String put(String key) {
        return this.unipoint(key);
    }

    public synchronized String unipoint(String key) {
        if (key == null) {
            return null;
        }
        StringSetry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        StringSetry e = tab[index];
        while (e != null) {
            if (e.hash == hash && CompareUtil.equals(e.key, key)) {
                return e.key;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new StringSetry(hash, key, tab[index]);
        ++this.count;
        return key;
    }

    public synchronized boolean remove(String key) {
        if (key == null) {
            return false;
        }
        StringSetry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        StringSetry e = tab[index];
        StringSetry prev = null;
        while (e != null) {
            if (e.hash == hash && CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public synchronized void clear() {
        StringSetry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        StringEnumer it = this.keys();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            buf.append(it.nextString());
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public static void main(String[] args) {
        HashSet<String> st = new HashSet<String>();
        st.add("sss1");
        st.add("sss2");
        st.add("sss3");
        System.out.println(st);
    }

    private class Enumer
    implements StringEnumer {
        StringSetry[] table;
        int index;
        StringSetry entry;

        Enumer() {
            this.table = StringSet.this.table;
            this.index = this.table.length;
            this.entry = null;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        @Override
        public String nextString() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                StringSetry e = this.entry;
                this.entry = e.next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static class StringSetry {
        int hash;
        String key;
        StringSetry next;

        protected StringSetry(int hash, String key, StringSetry next) {
            this.hash = hash;
            this.key = key;
            this.next = next;
        }

        protected Object clone() {
            return new StringSetry(this.hash, this.key, this.next == null ? null : (StringSetry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringSetry)) {
                return false;
            }
            StringSetry e = (StringSetry)o;
            return CompareUtil.equals(e.key, this.key);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

