/*
 * Decompiled with CFR 0.152.
 */
package scouterx.lib3.tomcat;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(SessionIdGenerator.class);
    private final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();
    private String secureRandomClass = null;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String secureRandomProvider = null;
    private String jvmRoute = "";
    private int sessionIdLength = 16;

    public void setSecureRandomClass(String secureRandomClass) {
        this.secureRandomClass = secureRandomClass;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public void setSecureRandomProvider(String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(int sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public String generateSessionId() {
        byte[] random = new byte[16];
        int sessionIdLength = this.getSessionIdLength();
        StringBuilder buffer = new StringBuilder(2 * sessionIdLength + 20);
        int resultLenBytes = 0;
        while (resultLenBytes < sessionIdLength) {
            this.getRandomBytes(random);
            for (int j = 0; j < random.length && resultLenBytes < sessionIdLength; ++resultLenBytes, ++j) {
                byte b1 = (byte)((random[j] & 0xF0) >> 4);
                byte b2 = (byte)(random[j] & 0xF);
                if (b1 < 10) {
                    buffer.append((char)(48 + b1));
                } else {
                    buffer.append((char)(65 + (b1 - 10)));
                }
                if (b2 < 10) {
                    buffer.append((char)(48 + b2));
                    continue;
                }
                buffer.append((char)(65 + (b2 - 10)));
            }
        }
        return buffer.toString();
    }

    protected void getRandomBytes(byte[] bytes) {
        SecureRandom random = this.randoms.poll();
        if (random == null) {
            random = this.createSecureRandom();
        }
        random.nextBytes(bytes);
        this.randoms.add(random);
    }

    private SecureRandom createSecureRandom() {
        SecureRandom result = null;
        long t1 = System.currentTimeMillis();
        if (this.secureRandomClass != null) {
            try {
                Class<?> clazz = Class.forName(this.secureRandomClass);
                result = (SecureRandom)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("sessionIdGeneratorBase.random {}", (Object)this.secureRandomClass, (Object)e);
            }
        }
        boolean error = false;
        if (result == null) {
            try {
                if (this.secureRandomProvider != null && this.secureRandomProvider.length() > 0) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm, this.secureRandomProvider);
                } else if (this.secureRandomAlgorithm != null && this.secureRandomAlgorithm.length() > 0) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm);
                }
            }
            catch (NoSuchAlgorithmException e) {
                error = true;
                log.error("sessionIdGeneratorBase.randomAlgorithm {}", (Object)this.secureRandomAlgorithm, (Object)e);
            }
            catch (NoSuchProviderException e) {
                error = true;
                log.error("sessionIdGeneratorBase.randomProvider {}", (Object)this.secureRandomProvider, (Object)e);
            }
        }
        if (result == null && error) {
            try {
                result = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                log.error("sessionIdGeneratorBase.randomAlgorithm {}", (Object)this.secureRandomAlgorithm, (Object)e);
            }
        }
        if (result == null) {
            result = new SecureRandom();
        }
        result.nextInt();
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 100L) {
            log.error("sessionIdGeneratorBase.createRandom {} {}", (Object)result.getAlgorithm(), (Object)(t2 - t1));
        }
        return result;
    }
}

