/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.TextPack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;
import scouter.util.Hexa32;
import scouter.util.LinkedMap;
import scouter.util.StringUtil;
import scouterx.webapp.framework.client.model.TextTypeEnum;
import scouterx.webapp.framework.client.net.TcpProxy;

public class TextModel {
    private static ThreadLocal<Set<Integer>> failedHashesInScope = new ThreadLocal();
    private static ThreadLocal<Boolean> scopeStarted = new ThreadLocal();
    private LinkedMap<Integer, String> entries = new LinkedMap();
    private final String cmd = "GET_TEXT_100";
    private final String type;
    private int limit;

    public static void startScope() {
        failedHashesInScope.set(new HashSet());
        scopeStarted.set(true);
    }

    public static void endScope() {
        failedHashesInScope.set(null);
        scopeStarted.set(false);
    }

    public static boolean isScopeStarted() {
        return scopeStarted.get();
    }

    public static void addFailedList(int hash) {
        failedHashesInScope.get().add(hash);
    }

    public static boolean isFailedInScope(int hash) {
        return failedHashesInScope.get().contains(hash);
    }

    public TextModel(String textType, int limit) {
        this.type = textType;
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        this.limit = limit;
    }

    public void setLimit(int limit) {
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getTextIfNullDefault(long date, int hash, int serverId) {
        if (hash == 0) {
            return "";
        }
        String text = this.getText(date, hash, serverId);
        if (StringUtils.isBlank((CharSequence)text)) {
            text = "**unlabeled**:" + TextTypeEnum.of(this).getTypeName() + ":" + hash;
        }
        return text;
    }

    public String getText(long date, int hash, int serverId) {
        if (hash == 0) {
            return null;
        }
        String value = this.getCachedText(hash);
        if (value != null) {
            return value;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(hash);
        String yyyymmdd = DateUtil.yyyymmdd((long)date);
        this.load(yyyymmdd, list, serverId);
        return this.getCachedText(hash);
    }

    public String getCachedText(int hash) {
        return (String)this.entries.get((Object)hash);
    }

    public String getCachedTextIfNullDefault(int hash) {
        if (hash == 0) {
            return "";
        }
        String s = (String)this.entries.get((Object)hash);
        if (s == null) {
            s = "**unlabeled**:" + TextTypeEnum.of(this).getTypeName() + ":" + hash;
        }
        return s;
    }

    public boolean load(String date, Collection<Integer> hashes, int serverId) {
        List<Pack> packList;
        if (hashes == null || hashes.size() == 0) {
            return false;
        }
        MapPack param = new MapPack();
        param.put("date", date);
        param.put("type", this.type);
        ListValue hashLv = param.newList("hash");
        Iterator<Integer> itr = hashes.iterator();
        Set<Integer> failedSet = failedHashesInScope.get();
        while (itr.hasNext()) {
            int key = itr.next();
            if (this.entries.containsKey((Object)key) || scopeStarted.get().booleanValue() && failedSet.contains(key)) continue;
            hashLv.add((long)key);
        }
        if (hashLv.size() == 0) {
            return false;
        }
        try (TcpProxy tcp = TcpProxy.getTcpProxy(serverId);){
            packList = tcp.process("GET_TEXT_100", (Pack)param);
        }
        if (packList == null) {
            return false;
        }
        for (Pack pack : packList) {
            MapPack re = (MapPack)pack;
            Iterator en = re.keys();
            while (en.hasNext()) {
                String key = (String)en.next();
                String value = re.getText(key);
                if (!StringUtil.isNotEmpty((String)value)) continue;
                int resultKey = (int)Hexa32.toLong32((String)key);
                this.cache(resultKey, value);
            }
        }
        if (scopeStarted.get().booleanValue()) {
            for (int i = 0; i < hashLv.size(); ++i) {
                if (this.entries.containsKey((Object)hashLv.getInt(i))) continue;
                failedSet.add(hashLv.getInt(i));
            }
        }
        return true;
    }

    public void cache(TextPack pack) {
        this.cache(pack.hash, pack.text);
    }

    public synchronized void cache(int hash, String value) {
        this.entries.put((Object)hash, (Object)value);
        if (this.entries.size() > this.limit) {
            this.entries.removeFirst();
        }
    }
}

