/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.net;

import java.util.ArrayList;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;

public class ConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    private static ConfigureAdaptor conf = ConfigureManager.getConfigure();
    private int poolSize;
    private LinkedList<TcpProxy> pool = new LinkedList();

    public ConnectionPool(int size) {
        this.poolSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TcpProxy getTcpProxy() {
        TcpProxy proxy;
        ArrayList<TcpProxy> proxyToClose = null;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.pool.size() == 0) {
                proxy = null;
            } else {
                proxy = this.pool.removeFirst();
                if (proxy.getLastUsed() < System.currentTimeMillis() - (long)(conf.getNetWebappTcpClientPoolTimeout() - 1)) {
                    proxyToClose = new ArrayList<TcpProxy>();
                    proxyToClose.add(proxy);
                    proxy = null;
                    if (this.pool.size() != 0 && (proxy = this.pool.removeFirst()).getLastUsed() < System.currentTimeMillis() - (long)(conf.getNetWebappTcpClientPoolTimeout() - 1)) {
                        proxyToClose.add(proxy);
                        proxy = null;
                    }
                }
            }
        }
        if (proxyToClose != null) {
            for (TcpProxy p : proxyToClose) {
                try {
                    p.realClose();
                }
                catch (Exception exception) {}
            }
        }
        return proxy;
    }

    public synchronized void initPool(int serverId) {
        this.closeAllInternal();
        this.createAllInternal(serverId);
    }

    public synchronized int getCurrentPoolSize() {
        return this.pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TcpProxy t) {
        TcpProxy removed = null;
        t.setLastUsed(System.currentTimeMillis());
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.pool.add(t);
            if (this.pool.size() > this.poolSize) {
                removed = this.pool.removeFirst();
            }
        }
        if (removed != null) {
            removed.realClose();
        }
    }

    public synchronized void closeAll() {
        this.closeAllInternal();
    }

    private void closeAllInternal() {
        while (this.pool.size() > 0) {
            this.pool.removeFirst().realClose();
        }
    }

    private void createAllInternal(int serverId) {
        this.put(new TcpProxy(serverId));
        this.put(new TcpProxy(serverId));
        this.put(new TcpProxy(serverId));
        this.put(new TcpProxy(serverId));
        this.put(new TcpProxy(serverId));
        this.put(new TcpProxy(serverId));
    }
}

