/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.net;

import scouter.Version;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CipherUtil;
import scouter.util.SysJMX;
import scouterx.webapp.framework.client.net.LoginRequest;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;

public class LoginMgr {
    public static LoginRequest login(Server server) {
        String encPassword = CipherUtil.sha256((String)server.getPassword());
        server.setSecureMode(true);
        return LoginMgr.loginInternal(server, server.getUserId(), encPassword);
    }

    public static LoginRequest loginInternal(Server server, String user, String encPassword) {
        LoginRequest result = new LoginRequest();
        try {
            MapPack param = new MapPack();
            param.put("id", user);
            param.put("pass", encPassword);
            param.put("version", Version.getClientFullVersion());
            param.put("hostname", SysJMX.getHostName());
            param.put("internal", "true");
            MapPack out = TcpProxy.loginByCleanConnection(server.getId(), param);
            if (out == null) {
                result.success = false;
                result.errorMessage = "Network connection failed";
            } else {
                Value menuV;
                long session = out.getLong("session");
                String error = out.getText("error");
                if (error != null && session == 0L) {
                    result.success = false;
                    result.errorMessage = "Authentication failed";
                    return result;
                }
                long time = out.getLong("time");
                String serverName = out.getText("server_id");
                String type = out.getText("type");
                String version = out.getText("version");
                String recommendedClientVersion = out.getText("client_version");
                String email = out.getText("email");
                String timezone = out.getText("timezone");
                int soTimeOut = out.getInt("so_time_out");
                server.setSession(session);
                server.setName(serverName);
                server.setDelta(time);
                server.setGroup(type);
                server.setVersion(version);
                server.setRecommendedClientVersion(recommendedClientVersion);
                server.setEmail(email);
                server.setTimezone(timezone);
                server.setSoTimeOut(soTimeOut);
                Value value = out.get("policy");
                if (value != null) {
                    MapValue mv = (MapValue)value;
                    server.setGroupPolicy(mv);
                }
                if ((menuV = out.get("menu")) != null) {
                    MapValue mv = (MapValue)menuV;
                    server.setMenuEnableMap(mv);
                }
                server.getConnectionPool().initPool(server.getId());
                server.setOpen(true);
                LoginMgr.refreshCounterEngine(server);
                result.success = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.success = false;
            result.errorMessage = "Network connection failed : " + e.getMessage();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapPack getCounterXmlServer(Server server) {
        TcpProxy tcp = TcpProxy.getTcpProxy(server);
        Pack p = null;
        try {
            p = tcp.getSingle("GET_XML_COUNTER", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            MapPack mapPack = null;
            return mapPack;
        }
        finally {
            TcpProxy.close(tcp);
        }
        return (MapPack)p;
    }

    public static void refreshCounterEngine(Server server) {
        CounterEngine counterEngine = new CounterEngine();
        MapPack m = LoginMgr.getCounterXmlServer(server);
        if (m != null) {
            Value v1 = m.get("default");
            counterEngine.parse(((BlobValue)v1).value);
            v1 = m.get("custom");
            if (v1 != null) {
                counterEngine.parse(((BlobValue)v1).value);
            }
            server.setCounterEngine(counterEngine);
        }
    }
}

