/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.net;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.Value;
import scouterx.webapp.framework.client.net.ClientTCP;
import scouterx.webapp.framework.client.net.ConnectionPool;
import scouterx.webapp.framework.client.net.INetReader;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;
import scouterx.webapp.framework.exception.ErrorState;

public class TcpProxy
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TcpProxy.class);
    private static final ConfigureAdaptor conf = ConfigureManager.getConfigure();
    private final ClientTCP tcp = new ClientTCP();
    private Server server;
    private long lastUsed;

    protected TcpProxy() {
    }

    protected TcpProxy(int serverId) {
        this.server = ServerManager.getInstance().getServer(serverId);
        log.info("TcpProxy created : pool-size:{}, {}", (Object)this.server.getConnectionPool().getCurrentPoolSize(), (Object)this);
    }

    public static synchronized TcpProxy getTcpProxy(Server server) {
        Server _server = ServerManager.getInstance().getServerIfNullDefault(server);
        if (_server == null || !_server.isOpen()) {
            throw ErrorState.COLLECTOR_NOT_CONNECTED.newBizException("server is not exist or before initializing! - " + (server == null ? "null" : String.valueOf(server.getId())));
        }
        ConnectionPool pool = _server.getConnectionPool();
        TcpProxy tcpProxy = pool.getTcpProxy();
        return tcpProxy != null ? tcpProxy : new TcpProxy(_server.getId());
    }

    public static synchronized TcpProxy getTcpProxy(int serverId) {
        return TcpProxy.getTcpProxy(ServerManager.getInstance().getServer(serverId));
    }

    public static synchronized void close(TcpProxy t) {
        if (t == null) {
            return;
        }
        try {
            t.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected ClientTCP getClientTcp() {
        return this.tcp;
    }

    public Server getServer() {
        return this.server;
    }

    public synchronized void open() {
        if (!this.tcp.connected()) {
            this.tcp.open(this.server.getId());
            if (!this.tcp.connected()) {
                this.server.setOpen(false);
            } else {
                this.server.setOpen(true);
            }
        }
    }

    public synchronized void realClose() {
        String lastStack = "";
        if (conf.isTrace()) {
            lastStack = Arrays.stream(new Exception().getStackTrace()).map(StackTraceElement::toString).limit(6L).collect(Collectors.joining("\\n "));
        }
        log.info("TcpProxy closed : pool-size:{}, {}, stack:{}", new Object[]{this.server.getConnectionPool().getCurrentPoolSize(), this, lastStack});
        this.sendClose();
        this.tcp.close();
    }

    protected void finalize() throws Throwable {
        this.tcp.close();
    }

    public Pack getSingle(String cmd, Pack param) {
        List<Pack> values = this.process(cmd, param);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public List<Pack> process(String cmd, Pack param) {
        ArrayList<Pack> list = new ArrayList<Pack>();
        this.process(cmd, param, in -> {
            Pack p = in.readPack();
            list.add(p);
        });
        return list;
    }

    public Value getSingleValue(String cmd, Pack param) {
        List<Value> values = this.processValues(cmd, param);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public Value getSingleValue(String cmd, Value param) {
        List<Value> values = this.processValues(cmd, param);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public List<Value> processValues(String cmd, Value param) {
        ArrayList<Value> list = new ArrayList<Value>();
        this.process(cmd, param, in -> {
            Value v = in.readValue();
            list.add(v);
        });
        return list;
    }

    public List<Value> processValues(String cmd, Pack param) {
        ArrayList<Value> list = new ArrayList<Value>();
        this.process(cmd, param, in -> {
            Value v = in.readValue();
            list.add(v);
        });
        return list;
    }

    public boolean isValid() {
        return this.tcp.connected();
    }

    public synchronized void process(String cmd, Object param, INetReader recv) {
        this.open();
        if (!this.tcp.connected()) {
            throw ErrorState.CLIENT_SOCKET_CLOSED.newBizException("[TcpProxy.process] client socket closed.");
        }
        long session = this.server.getSession();
        DataOutputX out = this.tcp.getOutput();
        DataInputX in = this.tcp.getInput();
        try {
            byte resFlag;
            out.writeText(cmd);
            out.writeLong(session);
            if (param instanceof Value) {
                out.writeValue((Value)param);
            } else if (param instanceof Pack) {
                out.writePack((Pack)param);
            }
            out.flush();
            while ((resFlag = in.readByte()) == 3) {
                recv.process(in);
            }
            if (resFlag == 68) {
                this.server.setSession(0L);
                this.tcp.close();
                throw ErrorState.COLLECTOR_INVALID_SESSION.newBizException();
            }
        }
        catch (Throwable e) {
            this.tcp.close();
            throw new RuntimeException(e);
        }
    }

    public synchronized void sendClose() {
        if (!this.tcp.connected()) {
            return;
        }
        DataOutputX out = this.tcp.getOutput();
        try {
            out.writeText("CLOSE");
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapPack loginByCleanConnection(int serverId, MapPack param) throws IOException {
        TcpProxy proxy = new TcpProxy(serverId);
        proxy.open();
        if (!proxy.isValid()) {
            return null;
        }
        param.put("ip", proxy.getLocalInetAddress().getHostAddress());
        DataOutputX out = proxy.getClientTcp().getOutput();
        DataInputX in = proxy.getClientTcp().getInput();
        try {
            out.writeText("LOGIN");
            out.writeLong(0L);
            out.writePack((Pack)param);
            out.flush();
            MapPack pack = null;
            while (in.readByte() == 3) {
                pack = (MapPack)in.readPack();
            }
            MapPack mapPack = pack;
            return mapPack;
        }
        finally {
            proxy.realClose();
        }
    }

    public InetAddress getLocalInetAddress() {
        return this.tcp.getSocket().getLocalAddress();
    }

    @Override
    public void close() {
        ConnectionPool pool = this.getServer().getConnectionPool();
        if (this.isValid()) {
            pool.put(this);
        } else {
            this.realClose();
        }
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }
}

