/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.counters.CounterEngine;
import scouter.lang.value.MapValue;
import scouter.util.HashUtil;
import scouterx.webapp.framework.client.net.ConnectionPool;
import scouterx.webapp.framework.client.thread.XLogRetrieveThread;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;

public class Server {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    ConfigureAdaptor conf = ConfigureManager.getConfigure();
    private final int id;
    private String name;
    private String ip;
    private int port;
    private ConnectionPool connPool;
    private long session;
    private long delta;
    private CounterEngine counterEngine;
    private XLogRetrieveThread xLogRetrieveThread;
    private String timezone;
    private String userId;
    private String encryptedPass;
    private String group;
    private String version;
    private String recommendedClientVersion;
    private String email;
    private boolean secureMode = true;
    private boolean open = false;
    private long usedMemory;
    private long totalMemory;
    private boolean dirty = false;
    private int soTimeOut = 15000;
    private MapValue groupPolicyMap = new MapValue();
    private MapValue menuEnableMap = new MapValue();

    public Server(String ip, String port) {
        this(ip, port, null);
    }

    public Server(String ip, String port, String name) {
        this.id = HashUtil.hash((String)(ip + port));
        this.ip = ip;
        this.port = Integer.valueOf(port);
        this.name = name;
        this.connPool = new ConnectionPool(this.conf.getNetWebappTcpClientPoolSize());
        this.counterEngine = new CounterEngine();
        this.xLogRetrieveThread = new XLogRetrieveThread(this);
        this.xLogRetrieveThread.start();
    }

    public int getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public ConnectionPool getConnectionPool() {
        return this.connPool;
    }

    public void close() {
        this.connPool.closeAll();
    }

    public long getSession() {
        return this.session;
    }

    public void setSession(long session) {
        this.session = session;
    }

    public long getDelta() {
        return this.delta;
    }

    public void setDelta(long serverTime) {
        this.delta = serverTime < 1L ? 0L : serverTime - System.currentTimeMillis();
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            return this.ip + ":" + this.port;
        }
        return this.name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.encryptedPass;
    }

    public void setPassword(String password) {
        this.encryptedPass = password;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRecommendedClientVersion() {
        return this.recommendedClientVersion;
    }

    public void setRecommendedClientVersion(String recommendedClientVersion) {
        this.recommendedClientVersion = recommendedClientVersion;
    }

    public void setGroupPolicy(MapValue mv) {
        this.groupPolicyMap = mv;
    }

    public boolean isAllowAction(String name) {
        return this.groupPolicyMap.getBoolean(name);
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public CounterEngine getCounterEngine() {
        return this.counterEngine;
    }

    public void setCounterEngine(CounterEngine counterEngine) {
        this.counterEngine = counterEngine;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public void setUsedMemory(long usedMemory) {
        this.usedMemory = usedMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void setMenuEnableMap(MapValue mv) {
        this.menuEnableMap = mv;
    }

    public boolean isEnableMenu(String key) {
        return this.menuEnableMap.getBoolean(key);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis() + this.getDelta();
    }

    public int getSoTimeOut() {
        return this.soTimeOut;
    }

    public void setSoTimeOut(int soTimeOut) {
        this.soTimeOut = soTimeOut;
    }

    public boolean isSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(boolean secureMode) {
        this.secureMode = secureMode;
    }

    public String toString() {
        return "Server [id=" + this.id + ", name=" + this.name + ", ip=" + this.ip + ", port=" + this.port + ", delta=" + this.delta + ", userId=" + this.userId + ", group=" + this.group + ", version=" + this.version + "]";
    }
}

