/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.layer.service.HostObjectRequestService;
import scouterx.webapp.model.HostDiskData;
import scouterx.webapp.model.ProcessObject;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/object/host")
@Api(value="Host object request")
@Singleton
@Produces(value={"application/json"})
public class HostObjectRequestController {
    @Context
    HttpServletRequest servletRequest;
    private final HostObjectRequestService objectRequestService = new HostObjectRequestService();

    @GET
    @ApiOperation(value="/realTime/top/ofObject/{objHash}", notes="Get system process information by TOP command.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/realTime/top/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<ProcessObject>> retrieveRealTimeTopByObjType(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        List<ProcessObject> processObjects = this.objectRequestService.retrieveRealTimeTopByObjType(objHash, server);
        return CommonResultView.success(processObjects);
    }

    @GET
    @ApiOperation(value="/realTime/disk/ofObject/{objHash}", notes="Get disk usage information")
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/realTime/disk/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<HostDiskData>> retrieveRealTimeDiskByObjType(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        List<HostDiskData> processObjects = this.objectRequestService.retrieveRealTimeDiskByObjType(objHash, server);
        return CommonResultView.success(processObjects);
    }
}

