/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import scouterx.webapp.framework.annotation.NoAuth;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.exception.ErrorStateBizException;
import scouterx.webapp.framework.exception.ErrorStateException;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v0/temp/test")
@Produces(value={"application/json"})
public class TempTestController {
    @GET
    public String check(@Context HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        session.setAttribute("testId", (Object)"testIdValue");
        return "OK";
    }

    @GET
    @Path(value="/more")
    @NoAuth
    public String checkMore() {
        return "OK-More";
    }

    @GET
    @Path(value="/todo")
    public ToDo checkTodo() {
        return new ToDo("morning todo", "brew a coffee", new Job("mytypes", "jobname!!"));
    }

    @GET
    @Path(value="/todoAsResult")
    public CommonResultView<ToDo> checkTodoAsResult() {
        ToDo todo = new ToDo("morning todo", "brew a coffee", new Job("mytypes", "jobname!!"));
        CommonResultView<ToDo> resultView = CommonResultView.success(todo);
        return resultView;
    }

    @GET
    @Path(value="/exception")
    public CommonResultView<ToDo> exception() {
        throw new RuntimeException("my exception");
    }

    @GET
    @Path(value="/exception/state")
    public CommonResultView<ToDo> exceptionState() {
        throw new ErrorStateException(ErrorState.INTERNAL_SERVER_ERROR, "test error state exception", new RuntimeException("my runtime ex!!!!!"));
    }

    @GET
    @Path(value="/exception/biz")
    public CommonResultView<ToDo> exceptionBizState() {
        throw new ErrorStateBizException(ErrorState.INTERNAL_SERVER_ERROR, "test error state BIZ !! exception");
    }

    @GET
    @Path(value="/map")
    public CommonResultView<Map<String, Object>> map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("1111", "asdf");
        map.put("2222", new Integer(22233));
        map.put("3333", 3333);
        return CommonResultView.success(map);
    }

    public static class Job {
        String type;
        String name;

        public void setType(String type) {
            this.type = type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        @ConstructorProperties(value={"type", "name"})
        public Job(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static class ToDo {
        String title;
        String desc;
        Job job2;

        public void setTitle(String title) {
            this.title = title;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public void setJob2(Job job2) {
            this.job2 = job2;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDesc() {
            return this.desc;
        }

        public Job getJob2() {
            return this.job2;
        }

        @ConstructorProperties(value={"title", "desc", "job2"})
        public ToDo(String title, String desc, Job job2) {
            this.title = title;
            this.desc = desc;
            this.job2 = job2;
        }
    }
}

