/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import scouterx.webapp.framework.annotation.NoAuth;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.layer.service.UserService;
import scouterx.webapp.layer.service.UserTokenService;
import scouterx.webapp.request.LoginRequest;
import scouterx.webapp.view.BearerTokenView;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/user")
@Api(value="User")
@Singleton
@Produces(value={"application/json"})
public class UserController {
    @Context
    HttpServletRequest servletRequest;
    final UserService userService = new UserService();
    final UserTokenService userTokenService = new UserTokenService();

    @NoAuth
    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> login(@Valid LoginRequest loginRequest) {
        this.userService.login(ServerManager.getInstance().getServer(loginRequest.getServerId()), loginRequest.getUser());
        this.servletRequest.getSession(true).setAttribute("userId", (Object)loginRequest.getUser().getId());
        return CommonResultView.success();
    }

    @NoAuth
    @POST
    @Path(value="/loginGetToken")
    @Consumes(value={"application/json"})
    public CommonResultView<BearerTokenView> login3rdParty(@Valid LoginRequest loginRequest) {
        Server server = ServerManager.getInstance().getServer(loginRequest.getServerId());
        this.userService.login(server, loginRequest.getUser());
        String bearerToken = this.userTokenService.publishToken(server, loginRequest.getUser());
        return CommonResultView.success(new BearerTokenView(true, bearerToken));
    }

    public static void main(String[] args) {
        SecureRandom rand = new SecureRandom();
        KeyGenerator generator = null;
        try {
            generator = KeyGenerator.getInstance("AES");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        generator.init(256, rand);
        SecretKey key = generator.generateKey();
    }
}

