/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.collections.CollectionUtils;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.VisitorService;
import scouterx.webapp.model.VisitorGroup;
import scouterx.webapp.request.VisitorGroupRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/visitor")
@Api(value="Visitor")
@Singleton
@Produces(value={"application/json"})
public class VisitorController {
    @Context
    HttpServletRequest servletRequest;
    private final VisitorService visitorService = new VisitorService();

    @GET
    @Path(value="/realTime/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Long> retrieveVisitorRealTimeByObj(@PathParam(value="objHash") int objHash, @QueryParam(value="serverId") int serverId) {
        Long visitorRealTime = this.visitorService.retrieveVisitorRealTimeByObj(objHash, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(visitorRealTime);
    }

    @GET
    @Path(value="/realTime/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Long> retrieveVisitorRealTimeByObjType(@NotNull @PathParam(value="objType") String objType, @QueryParam(value="serverId") int serverId) {
        Long visitorTotalRealTime = this.visitorService.retrieveVisitorRealTimeByObjType(objType, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(visitorTotalRealTime);
    }

    @GET
    @Path(value="/realTime")
    @Consumes(value={"application/json"})
    public CommonResultView<Long> retrieveVisitorRealtimeByObjHashes(@QueryParam(value="objHashes") String objHashes, @QueryParam(value="serverId") int serverId) {
        List<Integer> objList = ZZ.splitParamAsInteger(objHashes);
        if (CollectionUtils.isEmpty(objList)) {
            throw ErrorState.VALIDATE_ERROR.newBizException("Query parameter 'objHashes' is required!");
        }
        Long visitorGroupRealTime = this.visitorService.retrieveVisitorRealTimeByObjHashes(objList, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(visitorGroupRealTime);
    }

    @GET
    @Path(value="/{yyyymmdd}/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Long> retrieveVisitorByObj(@PathParam(value="yyyymmdd") String yyyymmdd, @PathParam(value="objHash") int objHash, @QueryParam(value="serverId") int serverId) {
        Long visitorLoadeddate = this.visitorService.retrieveVisitorByObj(objHash, yyyymmdd, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(visitorLoadeddate);
    }

    @GET
    @Path(value="{yyyymmdd}/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Long> retrieveVisitorTotalByObj(@PathParam(value="yyyymmdd") String yyyymmdd, @PathParam(value="objType") String objType, @QueryParam(value="serverId") int serverId) {
        Long visitorLoadeddate = this.visitorService.retrieveVisitorTotalByObj(objType, yyyymmdd, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(visitorLoadeddate);
    }

    @GET
    @Path(value="/ofObject/{objHashes}")
    @Consumes(value={"application/json"})
    public CommonResultView<VisitorGroup> retrieveVisitorGroupByObjHashes(@BeanParam @Valid VisitorGroupRequest visitorGroupRequest) {
        return this.retrieveVisitorGroup(visitorGroupRequest);
    }

    private CommonResultView<VisitorGroup> retrieveVisitorGroup(VisitorGroupRequest visitorGroupRequest) {
        visitorGroupRequest.validate();
        VisitorGroup visitorGroupLoaded = this.visitorService.retrieveVisitorGroupByObjHashes(visitorGroupRequest);
        return CommonResultView.success(visitorGroupLoaded);
    }

    @GET
    @Path(value="/hourly/ofObject/{objHashes}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<VisitorGroup>> retrieveVisitorHourlyGroupByObjHashes(@BeanParam @Valid VisitorGroupRequest visitorGroupRequest) {
        return this.retrieveVisitorHourlyGroup(visitorGroupRequest);
    }

    private CommonResultView<List<VisitorGroup>> retrieveVisitorHourlyGroup(VisitorGroupRequest visitorGroupRequest) {
        visitorGroupRequest.validate();
        List<VisitorGroup> visitorGroupLoadedList = this.visitorService.retrieveVisitorHourlyGroupByObjHashes(visitorGroupRequest);
        return CommonResultView.success(visitorGroupLoadedList);
    }
}

