/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.service;

import java.util.List;
import java.util.Map;
import scouter.lang.constants.ParamConstant;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.layer.consumer.CustomKvStoreConsumer;
import scouterx.webapp.model.KeyValueData;

public class CustomKvStoreService {
    private final CustomKvStoreConsumer kvStoreConsumer = new CustomKvStoreConsumer();

    public String get(String keySpace, String key, Server server) {
        return this.kvStoreConsumer.get(keySpace, key, server);
    }

    public boolean set(String keySpace, String key, String value, Server server) {
        return this.set(keySpace, key, value, ParamConstant.TTL_PERMANENT, server);
    }

    public boolean set(String keySpace, String key, String value, long ttl, Server server) {
        boolean result = this.kvStoreConsumer.set(keySpace, key, value, ttl, server);
        if (!result) {
            throw new RuntimeException("Error on setting value to kvstore!");
        }
        return true;
    }

    public boolean setTTL(String keySpace, String key, long ttl, Server server) {
        boolean result = this.kvStoreConsumer.setTTL(keySpace, key, ttl, server);
        if (!result) {
            throw new RuntimeException("Error on setting value to kvstore!");
        }
        return true;
    }

    public List<KeyValueData> getBulk(String keySpace, List<String> paramList, Server server) {
        return this.kvStoreConsumer.getBulk(keySpace, paramList, server);
    }

    public List<KeyValueData> setBulk(String keySpace, Map<String, String> paramMap, long ttl, Server server) {
        return this.kvStoreConsumer.setBulk(keySpace, paramMap, ttl, server);
    }
}

