/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model;

import java.beans.ConstructorProperties;
import scouter.lang.pack.MapPack;

public class VisitorGroup {
    private String time;
    private long value;

    public static VisitorGroup of(MapPack mapPack) {
        return VisitorGroup.builder().time(mapPack.getText("time")).value(mapPack.getLong("value")).build();
    }

    public static VisitorGroupBuilder builder() {
        return new VisitorGroupBuilder();
    }

    public String getTime() {
        return this.time;
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return "VisitorGroup(time=" + this.getTime() + ", value=" + this.getValue() + ")";
    }

    @ConstructorProperties(value={"time", "value"})
    public VisitorGroup(String time, long value) {
        this.time = time;
        this.value = value;
    }

    public static class VisitorGroupBuilder {
        private String time;
        private long value;

        VisitorGroupBuilder() {
        }

        public VisitorGroupBuilder time(String time) {
            this.time = time;
            return this;
        }

        public VisitorGroupBuilder value(long value) {
            this.value = value;
            return this;
        }

        public VisitorGroup build() {
            return new VisitorGroup(this.time, this.value);
        }

        public String toString() {
            return "VisitorGroup.VisitorGroupBuilder(time=" + this.time + ", value=" + this.value + ")";
        }
    }
}

