/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.scouter;

import scouter.lang.counters.CounterEngine;
import scouterx.webapp.framework.client.model.AgentModelThread;
import scouterx.webapp.framework.client.model.AgentObject;
import scouterx.webapp.framework.client.server.ServerManager;

public class SCounter {
    private int objHash;
    private String objName;
    private String name;
    private String displayName;
    private String unit;
    private Object value;

    public SCounter(int objHash, String name, Object value) {
        this.objHash = objHash;
        this.name = name;
        this.value = value;
        AgentObject agentObject = AgentModelThread.getInstance().getAgentObject(objHash);
        CounterEngine counterEngine = ServerManager.getInstance().getServerIfNullDefault(agentObject.getServerId()).getCounterEngine();
        this.displayName = counterEngine.getCounterDisplayName(agentObject.getObjType(), name);
        this.unit = counterEngine.getCounterUnit(agentObject.getObjType(), name);
        this.objName = agentObject.getObjName();
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getObjName() {
        return this.objName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUnit() {
        return this.unit;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "SCounter(objHash=" + this.getObjHash() + ", objName=" + this.getObjName() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", unit=" + this.getUnit() + ", value=" + this.getValue() + ")";
    }
}

