/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.List;
import scouter.lang.value.ListValue;
import scouter.util.DateTimeHelper;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.SummaryItem;

public class UserAgentSummaryItem
extends SummaryItem<UserAgentSummaryItem> {
    public UserAgentSummaryItem(int summaryKey, String summaryKeyName, int count) {
        this.summaryKey = summaryKey;
        this.summaryKeyName = summaryKeyName;
        this.count = count;
    }

    @Override
    public void merge(UserAgentSummaryItem newItem) {
        this.setCount(this.getCount() + newItem.getCount());
    }

    @Override
    public Summary<UserAgentSummaryItem> toSummary(List<DateAndMapPack> dnmPackList, int serverId) {
        Summary<UserAgentSummaryItem> summary = new Summary<UserAgentSummaryItem>();
        for (DateAndMapPack dnmPack : dnmPackList) {
            long date = DateTimeHelper.getDefault().yyyymmdd(dnmPack.getYyyymmdd());
            ListValue idList = dnmPack.getMapPack().getList("id");
            ListValue countList = dnmPack.getMapPack().getList("count");
            for (int i = 0; i < idList.size(); ++i) {
                UserAgentSummaryItem item = UserAgentSummaryItem.builder().summaryKey(idList.getInt(i)).summaryKeyName(TextProxy.userAgent.getTextIfNullDefault(date, idList.getInt(i), serverId)).count(countList.getInt(i)).build();
                summary.merge(item);
            }
        }
        return summary;
    }

    public static UserAgentSummaryItemBuilder builder() {
        return new UserAgentSummaryItemBuilder();
    }

    @Override
    public String toString() {
        return "UserAgentSummaryItem()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserAgentSummaryItem)) {
            return false;
        }
        UserAgentSummaryItem other = (UserAgentSummaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserAgentSummaryItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public UserAgentSummaryItem() {
    }

    public static class UserAgentSummaryItemBuilder {
        private int summaryKey;
        private String summaryKeyName;
        private int count;

        UserAgentSummaryItemBuilder() {
        }

        public UserAgentSummaryItemBuilder summaryKey(int summaryKey) {
            this.summaryKey = summaryKey;
            return this;
        }

        public UserAgentSummaryItemBuilder summaryKeyName(String summaryKeyName) {
            this.summaryKeyName = summaryKeyName;
            return this;
        }

        public UserAgentSummaryItemBuilder count(int count) {
            this.count = count;
            return this;
        }

        public UserAgentSummaryItem build() {
            return new UserAgentSummaryItem(this.summaryKey, this.summaryKeyName, this.count);
        }

        public String toString() {
            return "UserAgentSummaryItem.UserAgentSummaryItemBuilder(summaryKey=" + this.summaryKey + ", summaryKeyName=" + this.summaryKeyName + ", count=" + this.count + ")";
        }
    }
}

