/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;

public class CounterRequest {
    private final long limitRangeSec = 21600L;
    private int serverId;
    @NotNull
    @PathParam(value="counter")
    private String counter;
    @QueryParam(value="startYmdHms")
    private String startYmdHms;
    @QueryParam(value="endYmdHms")
    private String endYmdHms;
    @QueryParam(value="startTimeMillis")
    private long startTimeMillis;
    @QueryParam(value="endTimeMillis")
    private long endTimeMillis;

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.startYmdHms) || StringUtils.isNotBlank((CharSequence)this.endYmdHms)) {
            if (StringUtils.isBlank((CharSequence)this.startYmdHms) || StringUtils.isBlank((CharSequence)this.endYmdHms)) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmdHms and endYmdHms should be not null !");
            }
            if (this.startTimeMillis > 0L || this.endTimeMillis > 0L) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmdHms, endYmdHms and startTimeMillis, endTimeMills must not coexist!");
            }
            this.setTimeAsYmd();
        } else if (this.startTimeMillis <= 0L || this.endTimeMillis <= 0L) {
            throw ErrorState.VALIDATE_ERROR.newBizException("startTimeMillis and endTimeMillis must have value!");
        }
        if (this.endTimeMillis - this.startTimeMillis > 21600000L) {
            throw ErrorState.VALIDATE_ERROR.newBizException("query range should be lower than 21600 seconds!");
        }
    }

    private void setTimeAsYmd() {
        ZoneId zoneId = ZoneId.systemDefault();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime startDateTime = LocalDateTime.parse(this.startYmdHms, formatter);
        LocalDateTime endDateTime = LocalDateTime.parse(this.endYmdHms, formatter);
        this.startTimeMillis = startDateTime.atZone(zoneId).toEpochSecond() * 1000L;
        this.endTimeMillis = endDateTime.atZone(zoneId).toEpochSecond() * 1000L;
    }

    public long getLimitRangeSec() {
        return this.limitRangeSec;
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getCounter() {
        return this.counter;
    }

    public String getStartYmdHms() {
        return this.startYmdHms;
    }

    public String getEndYmdHms() {
        return this.endYmdHms;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public void setCounter(String counter) {
        this.counter = counter;
    }

    public void setStartYmdHms(String startYmdHms) {
        this.startYmdHms = startYmdHms;
    }

    public void setEndYmdHms(String endYmdHms) {
        this.endYmdHms = endYmdHms;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public String toString() {
        return "CounterRequest(limitRangeSec=" + this.getLimitRangeSec() + ", serverId=" + this.getServerId() + ", counter=" + this.getCounter() + ", startYmdHms=" + this.getStartYmdHms() + ", endYmdHms=" + this.getEndYmdHms() + ", startTimeMillis=" + this.getStartTimeMillis() + ", endTimeMillis=" + this.getEndTimeMillis() + ")";
    }
}

