/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.model.scouter.SDictionaryText;

public class DictionaryRequest {
    private static final char COLON = ':';
    @NotNull
    private Map<String, Set<SDictionaryText>> dictSets;
    private int serverId;
    @NotNull
    @PathParam(value="yyyymmdd")
    String yyyymmdd;

    @QueryParam(value="dictKeys")
    public void setDictSets(String dictKeys) {
        Set<String> textList = ZZ.splitParamStringSet(dictKeys);
        this.dictSets = textList.stream().map(s -> {
            String[] parts = StringUtils.split((String)s, (char)':');
            return new SDictionaryText(parts[0], Integer.valueOf(parts[1]), null);
        }).collect(Collectors.groupingBy(SDictionaryText::getTextType, Collectors.toSet()));
    }

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public Map<String, Set<SDictionaryText>> getDictSets() {
        return this.dictSets;
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getYyyymmdd() {
        return this.yyyymmdd;
    }

    public void setYyyymmdd(String yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
    }

    public String toString() {
        return "DictionaryRequest(dictSets=" + this.getDictSets() + ", serverId=" + this.getServerId() + ", yyyymmdd=" + this.getYyyymmdd() + ")";
    }
}

