/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;

public class LatestCounterRequest {
    private final int limitRangeSec = 3600;
    private int serverId;
    @NotNull
    @PathParam(value="counter")
    private String counter;
    @NotNull
    @PathParam(value="latestSec")
    private int latestSec;

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public void validate() {
        if (this.latestSec > 3600) {
            throw ErrorState.VALIDATE_ERROR.newBizException("query range should be lower than 3600 seconds!");
        }
    }

    public int getLimitRangeSec() {
        return this.limitRangeSec;
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getCounter() {
        return this.counter;
    }

    public int getLatestSec() {
        return this.latestSec;
    }

    public void setCounter(String counter) {
        this.counter = counter;
    }

    public void setLatestSec(int latestSec) {
        this.latestSec = latestSec;
    }

    public String toString() {
        return "LatestCounterRequest(limitRangeSec=" + this.getLimitRangeSec() + ", serverId=" + this.getServerId() + ", counter=" + this.getCounter() + ", latestSec=" + this.getLatestSec() + ")";
    }
}

