/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.ServiceCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.util.Pair;

public class ServiceASM
implements IASM,
Opcodes {
    private List<HookingSet> target;
    private Map<String, HookingSet> reserved;

    public ServiceASM() {
        this.target = HookingSet.getHookingMethodSet(Configure.getInstance().hook_service_patterns);
        this.reserved = new HashMap<String, HookingSet>();
        for (int i = ServiceTargetRegister.klassMethod.size() - 1; i >= 0; --i) {
            AsmUtil.add(this.reserved, ServiceTargetRegister.klassMethod.get(i).getLeft(), ServiceTargetRegister.klassMethod.get(i).getRight());
        }
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_serivce_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new ServiceCV(cv, mset, className, mset.xType == 0 ? (byte)1 : mset.xType);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new ServiceCV(cv, mset, className, mset.xType == 0 ? (byte)1 : mset.xType);
        }
        return cv;
    }

    public static class ServiceTargetRegister {
        public static final List<Pair<String, String>> klassMethod = new ArrayList<Pair<String, String>>();

        public static void regist(String klass, String method) {
            klassMethod.add(new Pair<String, String>(klass, method));
        }
    }
}

