/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import scouter.agent.Logger;
import scouter.agent.proxy.IElasticSearchTracer;
import scouter.agent.proxy.LoaderManager;
import scouter.agent.trace.TraceContext;

public class ElasticSearchTraceFactory {
    private static IElasticSearchTracer tracer;
    private static Object lock;
    private static final String CLIENT = "scouter.xtra.java8.ElasticSearchTracer";
    public static final IElasticSearchTracer dummy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IElasticSearchTracer create(ClassLoader parent) {
        try {
            if (tracer == null) {
                Object object = lock;
                synchronized (object) {
                    if (tracer == null) {
                        ClassLoader loader = LoaderManager.getOnlyForJava8Plus(parent);
                        if (loader == null) {
                            Logger.println("IElasticSearchTracer Client Load Error.. Dummy Loaded");
                            tracer = dummy;
                        } else {
                            Class<?> c = Class.forName(CLIENT, true, loader);
                            tracer = (IElasticSearchTracer)c.newInstance();
                        }
                    }
                }
            }
            return tracer;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.println("SC-145", "fail to create", e);
            return dummy;
        }
    }

    static {
        lock = new Object();
        dummy = new IElasticSearchTracer(){

            @Override
            public String getRequestDescription(TraceContext ctx, Object httpRequestBase) {
                return "-";
            }

            @Override
            public String getNode(TraceContext ctx, Object hostOrNode) {
                return "Unknown-ElasticSearch";
            }

            @Override
            public Throwable getResponseError(Object httpRequestBase0, Object httpResponse0) {
                return null;
            }
        };
    }
}

