/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import scouter.agent.Logger;
import scouter.agent.proxy.IKafkaTracer;
import scouter.agent.proxy.LoaderManager;

public class KafkaTraceFactory {
    private static IKafkaTracer kafkaTracer;
    private static Object lock;
    private static final String CLIENT = "scouter.xtra.kafka.KafkaTracer";
    public static final IKafkaTracer dummy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IKafkaTracer create(ClassLoader parent) {
        try {
            if (kafkaTracer == null) {
                Object object = lock;
                synchronized (object) {
                    if (kafkaTracer == null) {
                        ClassLoader loader = LoaderManager.getKafkaClient(parent);
                        if (loader == null) {
                            Logger.println("Kafka Client Load Error.. Dummy Loaded");
                            kafkaTracer = dummy;
                        } else {
                            Class<?> c = Class.forName(CLIENT, true, loader);
                            kafkaTracer = (IKafkaTracer)c.newInstance();
                        }
                    }
                }
            }
            return kafkaTracer;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.println("SC-145", "fail to create", e);
            return dummy;
        }
    }

    static {
        lock = new Object();
        dummy = new IKafkaTracer(){

            @Override
            public String getBootstrapServer(Object kafkaConfig) {
                return "dummy";
            }
        };
    }
}

