/*
 * Decompiled with CFR 0.152.
 */
package scouter.boot;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.TreeMap;
import scouter.boot.JarUtil;

public class Boot {
    public static void main(String[] args) throws Throwable {
        String lib = "./lib";
        if (args.length >= 1) {
            lib = args[0];
        }
        try {
            JarUtil.unJar(JarUtil.getThisJarFile(), new File(lib));
        }
        catch (Exception e) {
            System.out.println("Fail to extract jar files : " + e.toString());
            System.out.println("Please check the permission : " + lib + "/*.*");
        }
        URL[] jarfiles = Boot.getURLs(lib);
        URLClassLoader classloader = new URLClassLoader(jarfiles, Boot.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(classloader);
        String mainClass = System.getProperty("main", "scouter.agent.Main");
        try {
            Class<?> c = Class.forName(mainClass, true, classloader);
            Class[] argc = new Class[]{String[].class};
            Object[] argo = new Object[]{args};
            Method method = c.getDeclaredMethod("main", argc);
            method.invoke(null, argo);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            Boot.usage();
        }
    }

    private static void usage() {
        System.out.println("java -cp ./boot.jar scouter.boot.Boot [./lib] ");
    }

    private static URL[] getURLs(String path) throws IOException {
        TreeMap<String, File> jars = new TreeMap<String, File>();
        File[] files = new File(path).listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].getName().startsWith(".")) continue;
            jars.put(files[i].getName(), files[i]);
        }
        URL[] urls = new URL[jars.size()];
        ArrayList v = new ArrayList(jars.values());
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = ((File)v.get(i)).toURI().toURL();
        }
        return urls;
    }
}

