/*
 * Decompiled with CFR 0.152.
 */
package scouter.boot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.Uptime;
import scouter.util.ThreadUtil;

public class SigarTester {
    private static Sigar sigar = new Sigar();
    private HashMap<String, Map> previousNetworkStats = new HashMap();
    private HashMap<String, Map> previousDiskStats = new HashMap();

    public static void main(String[] args) {
        SigarTester tester = new SigarTester();
        tester.run();
        ThreadUtil.sleep((long)2000L);
        tester.run();
        ThreadUtil.sleep((long)2000L);
        tester.run();
        ThreadUtil.sleep((long)2000L);
        tester.run();
        ThreadUtil.sleep((long)2000L);
        tester.run();
        ThreadUtil.sleep((long)2000L);
        tester.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean skip = false;
        CpuInfo[] cpuinfo = null;
        CpuPerc[] cpuPerc = null;
        Mem mem = null;
        Swap swap = null;
        FileSystem[] fs = null;
        String[] netIf = null;
        Uptime uptime = null;
        double[] loadavg = null;
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            ArrayList<Double> list = new ArrayList<Double>();
            try {
                cpuinfo = sigar.getCpuInfoList();
                cpuPerc = sigar.getCpuPercList();
                ArrayList cpuList = new ArrayList();
                for (int i = 0; i < cpuinfo.length; ++i) {
                    HashMap<String, Double> cpuMap = new HashMap<String, Double>();
                    cpuMap.putAll(cpuinfo[i].toMap());
                    cpuMap.put("combined", cpuPerc[i].getCombined());
                    cpuMap.put("user", cpuPerc[i].getUser());
                    cpuMap.put("sys", cpuPerc[i].getSys());
                    cpuMap.put("idle", cpuPerc[i].getIdle());
                    cpuMap.put("wait", cpuPerc[i].getWait());
                    cpuMap.put("nice", cpuPerc[i].getNice());
                    cpuMap.put("irq", cpuPerc[i].getIrq());
                    cpuList.add(cpuMap);
                }
                sigar.getCpuPerc();
                map.put("cpu", cpuList);
                uptime = sigar.getUptime();
                map.put("uptime", Double.valueOf(uptime.getUptime()));
                loadavg = sigar.getLoadAverage();
                list.add(loadavg[0]);
                list.add(loadavg[1]);
                list.add(loadavg[2]);
            }
            catch (SigarException se) {
                se.printStackTrace();
            }
            finally {
                map.put("loadavg", list);
            }
            HashMap memMap = new HashMap();
            HashMap swapMap = new HashMap();
            try {
                mem = sigar.getMem();
                memMap.putAll(mem.toMap());
                swap = sigar.getSwap();
                swapMap.putAll(swap.toMap());
            }
            catch (SigarException se) {
                se.printStackTrace();
            }
            finally {
                map.put("memory", memMap);
                map.put("swap", swapMap);
            }
            ArrayList<Map> netInterfaces = new ArrayList<Map>();
            try {
                netIf = sigar.getNetInterfaceList();
                for (int i = 0; i < netIf.length; ++i) {
                    NetInterfaceStat net = new NetInterfaceStat();
                    try {
                        net = sigar.getNetInterfaceStat(netIf[i]);
                    }
                    catch (SigarException e) {
                        System.out.println("SigarException trying to stat network device " + netIf[i]);
                        continue;
                    }
                    HashMap netMap = new HashMap();
                    netMap.putAll(net.toMap());
                    if (this.previousNetworkStats.containsKey(netIf[i])) {
                        Map deltaMap = this.previousNetworkStats.get(netIf[i]);
                        deltaMap.put("RxBytes", Long.parseLong(netMap.get("RxBytes").toString()) - Long.parseLong(deltaMap.get("RxBytes").toString()));
                        deltaMap.put("RxDropped", Long.parseLong(netMap.get("RxDropped").toString()) - Long.parseLong(deltaMap.get("RxDropped").toString()));
                        deltaMap.put("RxErrors", Long.parseLong(netMap.get("RxErrors").toString()) - Long.parseLong(deltaMap.get("RxErrors").toString()));
                        deltaMap.put("RxPackets", Long.parseLong(netMap.get("RxPackets").toString()) - Long.parseLong(deltaMap.get("RxPackets").toString()));
                        deltaMap.put("TxBytes", Long.parseLong(netMap.get("TxBytes").toString()) - Long.parseLong(deltaMap.get("TxBytes").toString()));
                        deltaMap.put("TxCollisions", Long.parseLong(netMap.get("TxCollisions").toString()) - Long.parseLong(deltaMap.get("TxCollisions").toString()));
                        deltaMap.put("TxErrors", Long.parseLong(netMap.get("TxErrors").toString()) - Long.parseLong(deltaMap.get("TxErrors").toString()));
                        deltaMap.put("TxPackets", Long.parseLong(netMap.get("TxPackets").toString()) - Long.parseLong(deltaMap.get("TxPackets").toString()));
                        netInterfaces.add(deltaMap);
                        skip = false;
                    } else {
                        netInterfaces.add(netMap);
                        skip = true;
                    }
                    this.previousNetworkStats.put(netIf[i], netMap);
                }
            }
            catch (SigarException se) {
                se.printStackTrace();
            }
            finally {
                map.put("network", netInterfaces);
            }
            ArrayList<Map> fsList = new ArrayList<Map>();
            try {
                fs = sigar.getFileSystemList();
                for (int i = 0; i < fs.length; ++i) {
                    FileSystemUsage usage = sigar.getFileSystemUsage(fs[i].getDirName());
                    HashMap<String, Long> fsMap = new HashMap<String, Long>();
                    fsMap.putAll(fs[i].toMap());
                    fsMap.put("ReadBytes", usage.getDiskReadBytes());
                    fsMap.put("Reads", usage.getDiskReads());
                    fsMap.put("WriteBytes", usage.getDiskWriteBytes());
                    fsMap.put("Writes", usage.getDiskWrites());
                    if (this.previousDiskStats.containsKey(fs[i].getDevName())) {
                        Map deltaMap = this.previousDiskStats.get(fs[i].getDevName());
                        deltaMap.put("ReadBytes", usage.getDiskReadBytes() - (Long)deltaMap.get("ReadBytes"));
                        deltaMap.put("Reads", usage.getDiskReads() - (Long)deltaMap.get("Reads"));
                        deltaMap.put("WriteBytes", usage.getDiskWriteBytes() - (Long)deltaMap.get("WriteBytes"));
                        deltaMap.put("Writes", usage.getDiskWrites() - (Long)deltaMap.get("Writes"));
                        deltaMap.put("Total", usage.getTotal());
                        deltaMap.put("Used", usage.getUsed());
                        deltaMap.putAll(fs[i].toMap());
                        fsList.add(deltaMap);
                        skip = false;
                    } else {
                        fsList.add(fsMap);
                        skip = true;
                    }
                    this.previousDiskStats.put(fs[i].getDevName(), fsMap);
                }
            }
            catch (SigarException se) {
                se.printStackTrace();
            }
            finally {
                map.put("disk", fsList);
            }
            map.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        }
        catch (Exception se) {
            se.printStackTrace();
        }
    }
}

