/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import scouter.util.LongKeyMap;

public class CoroutineDebuggingLocal<T> {
    private static final ThreadLocal<Long> COROUTINE_DEBUGGING_ID = new ThreadLocal();
    private static final LongKeyMap CID_TRACE_CONTEXT = new LongKeyMap();

    public static void setCoroutineDebuggingId(Long id) {
        COROUTINE_DEBUGGING_ID.set(id);
    }

    public static Long getCoroutineDebuggingId() {
        return COROUTINE_DEBUGGING_ID.get();
    }

    public static void releaseCoroutineId() {
        COROUTINE_DEBUGGING_ID.remove();
    }

    public T get() {
        Long coroutineId = CoroutineDebuggingLocal.getCoroutineDebuggingId();
        if (coroutineId == null) {
            return null;
        }
        return (T)CID_TRACE_CONTEXT.get(coroutineId);
    }

    public T get(long id) {
        return (T)CID_TRACE_CONTEXT.get(id);
    }

    public void put(T obj) {
        Long coroutineId = CoroutineDebuggingLocal.getCoroutineDebuggingId();
        CID_TRACE_CONTEXT.put(coroutineId, obj);
    }

    public void clear() {
        Long coroutineId = CoroutineDebuggingLocal.getCoroutineDebuggingId();
        if (coroutineId == null) {
            return;
        }
        CID_TRACE_CONTEXT.put(coroutineId, null);
        CoroutineDebuggingLocal.releaseCoroutineId();
    }
}

