/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import java.net.URI;
import scouter.agent.Configure;
import scouter.agent.proxy.IHttpClient;
import scouter.agent.proxy.SpringRestTemplateHttpRequestFactory;
import scouter.agent.trace.ApiCallTransferMap;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ApiCallTraceHelper;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallStep2;
import scouter.util.IntKeyLinkedMap;

public class ForSpringAsyncRestTemplate
implements ApiCallTraceHelper.IHelper {
    private Configure conf = Configure.getInstance();
    private boolean ok = true;
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(5);

    @Override
    public ApiCallStep process(TraceContext ctx, HookArgs hookPoint) {
        ApiCallStep2 step = new ApiCallStep2();
        step.opt = 1;
        step.address = null;
        step.async = 1;
        if (this.ok) {
            try {
                URI uri = (URI)hookPoint.args[0];
                if (uri != null) {
                    ctx.apicall_target = step.address = uri.getHost() + ":" + uri.getPort();
                    ctx.apicall_name = uri.getPath();
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
        }
        if (ctx.apicall_name == null) {
            ctx.apicall_name = hookPoint.class1;
        }
        ctx.lastApiCallStep = step;
        return step;
    }

    @Override
    public void processEnd(TraceContext ctx, ApiCallStep step, Object rtn, HookArgs hookPoint) {
        if (step instanceof ApiCallStep2) {
            ApiCallTransferMap.put(System.identityHashCode(rtn), ctx, (ApiCallStep2)step);
        }
    }

    public void processSetCalleeToCtx(TraceContext ctx, Object _this, Object response) {
        IHttpClient httpclient = this.getProxy(_this);
        String calleeObjHashStr = httpclient.getResponseHeader(response, this.conf._trace_interservice_callee_obj_header_key);
        if (calleeObjHashStr != null) {
            try {
                ctx.lastCalleeObjHash = Integer.parseInt(calleeObjHashStr);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            ctx.lastCalleeObjHash = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(Object _this) {
        int key = System.identityHashCode(_this.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForSpringAsyncRestTemplate forSpringAsyncRestTemplate = this;
            synchronized (forSpringAsyncRestTemplate) {
                httpclient = SpringRestTemplateHttpRequestFactory.create(_this.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }
}

